<?php
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2011 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/



function wrapMultiData($field)
{
    global $sugar_config;
    $ret = '';
    if($sugar_config['dbconfig']['db_type']== "mysql"){
        $ret = "CONCAT('^', $field, '^')";
    } else if($sugar_config['dbconfig']['db_type']== "mssql")
    {
        $ret = "'^'+cast($field as varchar)+'^'";
    }
    return $ret;
}

function getMultiEnumFields($fieldDefs)
{
    $ret = array();
    foreach($fieldDefs as $field => $def)
    {
        if (isset($def['type']) && $def['type']=='multienum' && (!isset($def['source']) || $def['source'] == 'db'))
        {
            $ret[] = $def['name'];
        }
    }
    return $ret;
}

function getCustomMultiEnumFields($fieldDefs)
{
    $ret = array();
    foreach($fieldDefs as $field => $def)
    {
        if (isset($def['type']) && $def['type']=='multienum' && isset($def['source']) && $def['source'] == 'custom_fields')
        {
            $ret[] = $def['name'];
        }
    }
    return $ret;
}

function getUpdateQuery($fields, $table)
{
    if (empty($fields))
        return "";
    
    $query = "UPDATE $table SET";
    foreach($fields as $field)
    {
        $query .= " {$field}=" . wrapMultiData($field) . ",";
    }
    $query = substr($query, 0, strlen($query) -1);
    
    return $query;
}



function upgrade_multienum_data(){
    require_once("include/SugarObjects/VardefManager.php");
    global $dictionary, $db, $moduleList, $beanList, $sugar_version;
    
    if ($_SESSION['current_db_version'] >= 550)
        return;
        
    
         
    foreach($moduleList as $module) 
    {
        if (empty($beanList[$module]))
            continue;
        $beanName = $beanList[$module];
        VardefManager::loadVardef($module, $beanName);
        if (empty($dictionary[$beanName]))
            continue;
        $def = $dictionary[$beanName];
        $query = "";
        if (!empty ($def['table']) && !empty($def['fields']))
        {
            $table = $def['table'];
            $fields = getMultiEnumFields($def['fields']);
            $customFields = getCustomMultiEnumFields($def['fields']);
            if (empty($fields) && empty($customFields))
                continue;
            $query  = getUpdateQuery($fields, $table);
            if (!empty($query))
            {
                $db->query($query);
            }
            $query = getUpdateQuery($customFields, $table . "_cstm");
            if (!empty($query))
            {
                $db->query($query);
            }
        }
    }   
}
    
?>
