<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*
 * @package TCPDF for SugarCRM
 * @copyright 2007-2009 Extra Solution s.r.o.  http://www.extrasolution.com/
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact Extra Solution at email address support@extrasolution.com.
 * 
 */
 


require_once('include/MVC/Tcpdf/SugarTcpdf.php');

class CustomTcpdf extends SugarTcpdf
{
	
    function preDisplay()
    {
		// set document information
		$this->bean->format_all_fields();
		
		//Set document properties
		$this->SetCreator(PDF_CREATOR);
		$this->SetAuthor('User AAA');
		$this->SetTitle('Company ABC');
		$this->SetSubject('TCPDF support for SugarCRM');
		$this->SetKeywords('TCPDF, SugarCRM');
    	
    	// set default header data
		$this->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, $this->bean->GetObjectName(), get_class($this).' extends '.get_parent_class($this));
		
		// set header and footer fonts
		$this->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$this->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
		
		//set margins
		$this->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$this->SetHeaderMargin(PDF_MARGIN_HEADER);
		$this->SetFooterMargin(PDF_MARGIN_FOOTER);
		
		//set auto page breaks
		$this->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		
		//set image scale factor
		$this->setImageScale(PDF_IMAGE_SCALE_RATIO); 
		
		//set some language-dependent strings
		//$this->setLanguageArray($l); 
		
		// ---------------------------------------------------------    	
    	
    }

    /**
     * [OVERRIDE] - This method is meant to overidden in a subclass. This method
     * will handle the actual display logic of the view.
     */
    function display()
    {
    	$this->AddPage();
    	$this->MultiCell(0,0,'Custom base class for other PDFs.',0,'L');
		$this->Info();

    }
    
	function GetBeanString($field) {
 	 	$value = $this->bean->getFieldValue($field);
 		if (is_object($value))
 			{
				$class = new ReflectionObject($value);
				if ($class->hasMethod('__toString')) {
				    return $value;
				} else {
				    return 'Instance of ' . $class->getName();
				}
 			} else {
 				return $value;
 			}
 	}
 	
 	
 	function WrapTD($html, $width=100, $align='left')
 	{
 		$align = strtolower($align);
    	switch($align) {
	        case 'l': $align = 'left'; break;
	        case 'r': $align = 'right'; break;
	        case 'c': $align = 'center'; break;
    	}
    	
 		return "<td width='".$width."' align='".$align."'>".$html."</td>";
 		
 	}
 	
 	function WrapTR($html, $bgcolor='')
 	{
 		if ($bgcolor !='')
 		{
 			return "<tr bgcolor='".$bgcolor."'>".$html."</tr>";
 		} else {
 			return "<tr>".$html."</tr>";
 		}
 	}
 	
 	function WrapTable($html, $cellpadding = 5, $border=0)
 	{
 		return "<table cellpadding='".$cellpadding."' border='".$border."'>".$html."</table>";
 	}
 	
 	function WrapB($html)
 	{
 		return "<b>".$html."</b>";
 	}
 	
	function WrapI($html)
 	{
 		return "<i>".$html."</i>";
 	}
 	
 	function WrapLabelValue($htmllabel,$htmlvalue)
 	{
 		return $this->WrapTD($htmllabel,100).$this->WrapTD($htmlvalue,150);
 	}
  	
    
}


