<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*
 * @package TCPDF for SugarCRM
 * @copyright 2007-2009 Extra Solution s.r.o.  http://www.extrasolution.com/
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact Extra Solution at email address support@extrasolution.com.
 * 
 */

if(file_exists('custom/include/MVC/Tcpdf/tcpdf_config.php')){
	require_once('custom/include/MVC/Tcpdf/tcpdf_config.php');
} else {
	require_once('include/MVC/Tcpdf/tcpdf_config.php');
}

require_once('include/tcpdf/tcpdf.php');

class SugarTcpdf extends TCPDF
{

    /**
     * This array is meant to hold an objects/data that we would like to pass between
     * the controller and the view.  The bean will automatically be set for us, but this
     * is meant to hold anything else.
     */
    var $tcpdf_object_map = array();
    /**
     * The name of the current module.
     */
    var $module = '';
    /**
     * The name of the current action.
     */
    var $action = '';
    /**
     */
    var $bean = null;
     /**
     * Any errors that occured this can either be set by the view or the controller or the model
     */
    var $errors = array();
    /**
     * Constructor which will peform the setup.
     */
    
   
    function __construct($bean = null, $tcpdf_object_map = array(),$orientation=PDF_PAGE_ORIENTATION, $unit=PDF_UNIT, $format=PDF_PAGE_FORMAT, $unicode=true, $encoding='UTF-8', $diskcache=false){
    	parent::__construct($orientation,$unit,$format,$unicode,$encoding,$diskcache);
    	$this->module = $GLOBALS['module'];
    	$this->bean = &$bean;
    	$this->tcpdf_object_map = $tcpdf_object_map;
    	$this->action = $_REQUEST["tcpdf"];
    }

    /**
     * This method will be called from the controller and is not meant to be overridden.
     */
    function process()
    {
        //$this->buildModuleList();
        $this->preDisplay();
        //$this->displayErrors();
        $this->display();

    }

    /**
     * This method will display the errors on the page.
     */
    function displayErrors()
    {
        foreach($this->errors as $error) {
            echo '<span class="error">' . $error . '</span><br>';
        }
    }

    /**
     * [OVERRIDE] - This method is meant to overidden in a subclass. The purpose of this method is
     * to allow a view to do some preprocessing before the display method is called. This becomes
     * useful when you have a view defined at the application level and then within a module
     * have a sub-view that extends from this application level view.  The application level
     * view can do the setup in preDisplay() that is common to itself and any subviews
     * and then the subview can just override display(). If it so desires, can also override
     * preDisplay().
     */
    function preDisplay()
    {
		// set document information
		$this->SetCreator(PDF_CREATOR);
		$this->SetAuthor('www.extrasolution.com');
		$this->SetTitle('TCPDF For SugarCRM');
		$this->SetSubject('TCPDF support for SugarCRM');
		$this->SetKeywords('TCPDF, PDF, SugarCRM');
    	
    	// set default header data
		$this->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, $this->module, $this->action);
		
		// set header and footer fonts
		$this->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$this->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
		
		//set margins
		$this->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$this->SetHeaderMargin(PDF_MARGIN_HEADER);
		$this->SetFooterMargin(PDF_MARGIN_FOOTER);
		
		//set auto page breaks
		$this->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		
		//set image scale factor
		$this->setImageScale(PDF_IMAGE_SCALE_RATIO); 
		
		//set some language-dependent strings
		//$this->setLanguageArray($l); 
		
		// ---------------------------------------------------------    	
    	
    }

    /**
     * [OVERRIDE] - This method is meant to overidden in a subclass. This method
     * will handle the actual display logic of the view.
     */
    function display()
    {
		$this->AddPage();
    	$this->SetFont(PDF_FONT_NAME_MAIN,'B',16);
		$this->MultiCell(0,0,'Tcpdf class for this module and action has not been implemented.',0,'C');
    	$this->Info();


    }
    
    function Info()
    {
		
    	$this->SetFont(PDF_FONT_NAME_MAIN,'',12);
    	$this->MultiCell(0,0,'---',0,'L');
		$this->MultiCell(0,0,'Class: '.get_class($this),0,'L');
		$this->MultiCell(0,0,'Extends: '.get_parent_class($this),0,'L');
		$this->MultiCell(0,0,'---',0,'L');
		$this->MultiCell(0,0,'Module: '.$this->module,0,'L');
		$this->MultiCell(0,0,'Tcpdf Action: '.$this->action,0,'L');
		$this->MultiCell(0,0,'Bean ID: '.$this->bean->getFieldValue('id'),0,'L');
		$this->SetFont(PDF_FONT_NAME_MAIN,'',12);
		$this->MultiCell(0,0,'---',0,'L');

    }
    
}

