<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*
 * @package TCPDF for SugarCRM
 * @copyright 2007-2009 Extra Solution s.r.o.  http://www.extrasolution.com/
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact Extra Solution at email address support@extrasolution.com.
 * 
 */

require_once('include/MVC/Tcpdf/SugarTcpdf.php');

class TcpdfFactory{
	/**
	 * load the correct Tcpdf
	 * @param string $type Tcpdf Type
	 * @return valid Tcpdf
	 */
	function loadTcpdf($type = 'default', $module, $bean = null, $tcpf_object_map = array()){
		$type = strtolower($type);
		//TcpdfFactory::_loadConfig($tcpdf, $type);
		//first let's check if the module handles this Tcpdf
		$tcpdf = null;
		$path = '/tcpdf/tcpdf.'.$type.'.php';
		if(file_exists('custom/modules/'.$module.$path)){
			$tcpdf = TcpdfFactory::_buildFromFile('custom/modules/'.$module.$path, $bean, $tcpdf_object_map, $type, $module);
		}else if(file_exists('modules/'.$module.$path)){
			$tcpdf = TcpdfFactory::_buildFromFile('modules/'.$module.$path, $bean, $tcpdf_object_map, $type, $module);
		}else if(file_exists('custom/include/MVC/Tcpdf'.$path)){
			$tcpdf = TcpdfFactory::_buildFromFile('custom/include/MVC/Tcpdf'.$path, $bean, $tcpdf_object_map, $type, $module);
		}else{
			//if the module does not handle this Tcpdf, then check if Sugar handles it OOTB
			$file = 'include/MVC/Tcpdf'.$path;
			if(file_exists($file)){
				//it appears Sugar does have the proper logic for this file.
				$tcpdf = TcpdfFactory::_buildFromFile($file, $bean, $tcpdf_object_map, $type, $module);
			}
		}	
		// Default to SugarTcpdf if still nothing found/built
		if (!isset($tcpdf)) 
			$tcpdf = new SugarTcpdf($bean, $tcpdf_object_map);
		return $tcpdf;
	}
	
	/**
	 * Load the Tcpdf_<Tcpdf>_config.php file which holds options used by the tcpdf.
	 */
//	function _loadConfig(&$tcpdf, $type){
////		$tcpdf_config_custom = array();
////		$tcpdf_config_module = array();
////		$tcpdf_config_root_cstm = array();
////		$tcpdf_config_root = array();
////		$tcpdf_config_app = array();
//		$config_file_name = 'tcpdf.'.$type.'.config.php';
//		//echo ' <br /> '.$config_file_name.' <br />';
//		//$tcpdf_config = sugar_cache_retrieve("TCPDF_CONFIG_FILE_".$tcpdf->module."_TYPE_".$type);
//		if(!$tcpdf_config){
//			if(file_exists('custom/modules/'.$tcpdf->module.'/tcpdf/'.$config_file_name)){
//				require_once('custom/modules/'.$tcpdf->module.'/tcpdf/'.$config_file_name);
//			} 
//			if(file_exists('modules/'.$tcpdf->module.'/tcpdf/'.$config_file_name)){
//				require_once('modules/'.$tcpdf->module.'/tcpdf/'.$config_file_name);
//			}
//			if(file_exists('custom/include/MVC/Tcpdf/tcpdf/'.$config_file_name)){
//				require_once('custom/include/MVC/Tcpdf/tcpdf/'.$config_file_name);
//			}
//			if(file_exists('include/MVC/Tcpdf/tcpdf/'.$config_file_name)){
//				require_once('include/MVC/Tcpdf/tcpdf/'.$config_file_name);
//			}	
//			if(file_exists('include/MVC/Tcpdf/tcpdf/tcpdf.config.php')){
//				require_once('include/MVC/Tcpdf/tcpdf/tcpdf.config.php');
//			}
//		}
//
//	}	
	
	/**
	 * This is a private function which just helps the getTcpdf function generate the
	 * proper Tcpdf object
	 * 
	 * @return a valid SugarTcpdf
	 */
	function _buildFromFile($file, &$bean, $tcpdf_object_map, $type, $module){
		require_once($file);
		//try ModuleTcpdfType first then try TcpdfType if that fails then use SugarTcpdf
		$class = ucfirst($module).'Tcpdf'.ucfirst($type);
		if(!class_exists($class)){
			$class = 'Tcpdf'.ucfirst($type);
			if(!class_exists($class)){
				return new SugarTcpdf($bean, $tcpdf_object_map);
			}
		}
		return TcpdfFactory::_buildClass($class, $bean, $tcpdf_object_map);	
	}
	
	/**
	 * instantiate the correct Tcpdf and call init to pass on any obejcts we need to
	 * from the controller.
	 * 
	 * @param string class - the name of the class to instantiate
	 * @param object bean = the bean to pass to the Tcpdf
	 * @param array Tcpdf_object_map - the array which holds obejcts to pass between the
	 *                                controller and the tcpdf.
	 * 
	 * @return SugarTcpdf
	 */
	function _buildClass($class, &$bean, $tcpdf_object_map){
		

		$tcpdf = new $class($bean, $tcpdf_object_map);
		//$tcpdf->init($bean, $tcpdf_object_map);
		if($tcpdf instanceof SugarTcpdf){
			return $tcpdf;
		}else
			return new SugarTcpdf($bean, $tcpdf_object_map);
	}
}
?>
