<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*
 * @package TCPDF for SugarCRM
 * @copyright 2007-2009 Extra Solution s.r.o.  http://www.extrasolution.com/
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact Extra Solution at email address support@extrasolution.com.
 * 
 */

require_once('include/MVC/Tcpdf/SugarTcpdf.php');

class TcpdfCodetable extends SugarTcpdf
{
    
function preDisplay()
    {
    	parent::preDisplay();
    	//$this->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, 'TCPDF CodeTable', date("Y-m-d H:m:s"));
    }	
	
	function display()
    {
		 	
 		global $mod_strings;
   		global $app_strings;
   		$width_label = '$wl'; 
   		$width_value = '$wv';
   		$cell_height = '$ch';
   		
   		
		$this->AddPage();
 		$this->SetFont(PDF_FONT_NAME_MAIN,'',8);
 		
 		// Define variables
 		$this->MultiCell(0,0, '$fd = $this->bean->GetFieldDefinitions();' ,0,'L');
 		$this->MultiCell(0,0, $width_label.' = 100; //Width of Labels' ,0,'L');
 		$this->MultiCell(0,0, $width_value.' = 150; //Width of Values' ,0,'L');
  		$this->MultiCell(0,0, $cell_height.' = 5; //Minimum height of Multicell' ,0,'L');
   		
  		//Table generation
 		$this->MultiCell(0,0, '$html = \'<table cellpadding=\\\'5\\\' border=\\\'1\\\'>\';' ,0,'L');
 		
		foreach($this->bean->GetFieldDefinitions() as $key => $value)
		{
			
			//$this->SetY($this->GetY() + 10);
			//$this->MultiCell(50,6, $value['name'] ,0,'L',0,0);
			$this->MultiCell(0,0, '$html .= \'<tr>\';' ,0,'L');
			$txt = '$html .= \'<td width=\\\'\' . ' .$width_label . ' . \'\\\'>\' . $mod_strings[$fd[\'' . $value['name'] . '\'][\'vname\']]' . ' . \'</td>\';';
			$this->MultiCell(0,0, $txt ,0,'L');
			$txt = '$html .= \'<td width=\\\'\' . ' . $width_value . ' . \'\\\'>\'' . ' . $this->bean->getFieldValue(\''.$value['name'].'\')'.' . \'</td>\';';
			$this->MultiCell(0,0, $txt ,0,'L');
			$this->MultiCell(0,0, '$html .= \'</tr>\';' ,0,'L');
			
		}
		//$this->SetY($this->GetY() + 10);
		$this->MultiCell(0,0, '$html .= \'</table>\';' ,0,'L');
		$this->MultiCell(0,0, '$this->WriteHTML($html);' ,0,'L');
		

    }
    
    function _GetString($field) {
 	 	$value = $this->bean->getFieldValue($field);
 		if (is_object($value))
 			{
				$class = new ReflectionObject($value);
				if ($class->hasMethod('__toString')) {
				    return $value;
				} else {
				    return 'Instance of ' . $class->getName();
				}
 			} else {
 				return $value;
 			}
 	}
  	
    
}


