<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*
 * @package TCPDF for SugarCRM
 * @copyright 2007-2009 Extra Solution s.r.o.  http://www.extrasolution.com/
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact Extra Solution at email address support@extrasolution.com.
 * 
 */

require_once('include/MVC/Tcpdf/SugarTcpdf.php');

class TcpdfCodewraptable extends SugarTcpdf
{
    
function preDisplay()
    {
    	parent::preDisplay();
    	//$this->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, 'TCPDF CodeTable', date("Y-m-d H:m:s"));
    }	
	
	function display()
    {
		 	
 		global $mod_strings;
   		global $app_strings;
   		$width_label = '$wl'; 
   		$width_value = '$wv';
   		$cell_height = '$ch';
   		$tabs = '//      ';
   		
		$this->AddPage();
 		$this->SetFont(PDF_FONT_NAME_MAIN,'',8);
 		
 		// Define variables
 		$this->MultiCell(0,0, $tabs.'$fd = $this->bean->GetFieldDefinitions();' ,0,'L');
 		$this->MultiCell(0,0, $tabs.$width_label.' = 100; //Width of Labels' ,0,'L');
 		$this->MultiCell(0,0, $tabs.$width_value.' = 150; //Width of Values' ,0,'L');
  		$this->MultiCell(0,0, $tabs.$cell_height.' = 5; //Minimum height of Multicell' ,0,'L');
   		
  		require_once('modules/'.$this->bean->module_dir.'/metadata/detailviewdefs.php');
	
		$txt = '$html = \'\';';
		$this->MultiCell(0,0, $txt ,0,'L');
		foreach($viewdefs[$this->bean->module_dir]['DetailView']['panels']['default'] as $key => $value)
		{
			$txtdot = '';
			foreach($value as $key1 => $val1) {
				$txt = '$line '.$txtdot.'= $this->WrapLabelValue($mod_strings[\''.$val1['label'].'\'],$this->bean->getFieldValue(\''.$val1['name'].'\'));';
				$this->MultiCell(0,0, $txt ,0,'L');
				$txtdot = '.';
			}
			$txt = '$html .= $this->WrapTR($line);';
			$this->MultiCell(0,0, $txt ,0,'L');
		}
		$txt = '$html = $this->WrapTable($html,3,1);';
		$this->MultiCell(0,0, $txt ,0,'L');
		$txt = '$this->WriteHTML($html);';
		$this->MultiCell(0,0, $txt ,0,'L');
    }
    
    function _GetString($field) {
 	 	$value = $this->bean->getFieldValue($field);
 		if (is_object($value))
 			{
				$class = new ReflectionObject($value);
				if ($class->hasMethod('__toString')) {
				    return $value;
				} else {
				    return 'Instance of ' . $class->getName();
				}
 			} else {
 				return $value;
 			}
 	}
  	
    
}


