<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*
 * @package TCPDF for SugarCRM
 * @copyright 2007-2009 Extra Solution s.r.o.  http://www.extrasolution.com/
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact Extra Solution at email address support@extrasolution.com.
 * 
 */

require_once('include/MVC/Tcpdf/SugarTcpdf.php');

class TcpdfFieldlist extends SugarTcpdf
{
    
function preDisplay()
    {
    	parent::preDisplay();
    	$this->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, 'TCPDF Fields', date("Y-m-d H:m:s"));
    }	
	
	function display()
    {
		 	
 		global $mod_strings;
   		global $app_strings;
		$this->AddPage();
 	
		$html .= '<table cellspacing=\'5\' border=\'0\'>';
		foreach($this->bean->GetFieldDefinitions() as $key => $value)
		{
			$html .= '<tr>';
			$html .= '<td width=\'150\'>'.$mod_strings[$value['vname']].'</td>';
			$html .= '<td width=\'350\'><b>'.$this->_GetString($value['name']).'</b></td>';
			$html .= '</tr>';
			
		}
		$html .= '</table>';
		$this->WriteHTML($html);

    }
    
    function _GetString($field) {
 	 	$value = $this->bean->getFieldValue($field);
 		if (is_object($value))
 			{
				$class = new ReflectionObject($value);
				if ($class->hasMethod('__toString')) {
				    return $value;
				} else {
				    return 'Instance of ' . $class->getName();
				}
 			} else {
 				return $value;
 			}
 	}
  	
    
}


