<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*
 * @package TCPDF for SugarCRM
 * @copyright 2007-2009 Extra Solution s.r.o.  http://www.extrasolution.com/
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact Extra Solution at email address support@extrasolution.com.
 * 
 */

require_once('include/MVC/Tcpdf/SugarTcpdf.php');



class TcpdfFields extends SugarTcpdf
{
    
function preDisplay()
    {
    	parent::preDisplay();
    	$this->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, 'TCPDF Fields', date("Y-m-d H:m:s"));
    }	
	
	function display()
    {
		 	
 		global $mod_strings;
   		global $app_strings;
   		
   		$this->AddPage();
   		
   		//Get Metadata file
   		$path_metadata = 'modules/'.$this->bean->module_dir.'/metadata/detailviewdefs.php';
		if( file_exists('custom/'.$path_metadata)){
			$path_metadata = 'custom/'.$path_metadata;
			require_once($path_metadata);
		} else if (file_exists($path_metadata)) {
			require_once($path_metadata); 
		} else {
			$this->MultiCell(0,0, 'Report does not support "Classic Mode" (pre 5.x rendering).',0,'L');
			$this->MultiCell(0,0, 'Missing metadata file: '.$path_metadata ,0,'L');
			return;		
		}
		
		//TODO Resolve how to recognise supported detail view format
		
		//HACK Suppose that default panel exists
		if (!is_array($viewdefs[$this->bean->module_dir]['DetailView']['panels']['default'])) {
			$this->MultiCell(0,0, 'Unsupported metadata format in: '. $path_metadata ,0,'L');
			$this->MultiCell(0,0, 'Try: Admin->Studio and create custom detail layout. ' ,0,'L');
			return;
	    }
		//HACK END
		
		foreach($viewdefs[$this->bean->module_dir]['DetailView']['panels'] as $key => $val)
		{
			$this->WriteHTML($mod_strings[$key].'<br />');
			$html = '<table cellspacing=\'5\' border=\'0\'>';
			foreach($val as $key1 => $val1)
			{
				$html .= '<tr>';
				foreach($val1 as $key2 => $val2) {
					$html .= '<td width=\'100\'>'.$mod_strings[$val2['label']].'</td>';
					$html .= '<td width=\'165\'><b>'.$this->GetString($val2['name']).'</b></td>';
				}
				$html .= '</tr>';
				
			}
			$html .= '</table>';
			$this->WriteHTML($html);
			$this->Ln();
			$this->Line($this->GetX(),$this->GetY(),$this->GetX() + $this->getPageWidth()*0.8,$this->GetY());
    	}
		
		
		$this->Info();

    }
    
    function GetString($field) {
 	 	$value = $this->bean->getFieldValue($field);
 		if (is_object($value))
 			{
				$class = new ReflectionObject($value);
				if ($class->hasMethod('__toString')) {
				    return $value;
				} else {
				    return 'Instance of ' . $class->getName();
				}
 			} else {
 				return $value;
 			}
 	}
  	
    
}


