<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*********************************************************************************
 * The contents of this file are subject to the SugarCRM Public License Version
 * 1.1.3 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.sugarcrm.com/SPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by SugarCRM" logo and
 *    (ii) the SugarCRM copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: SugarCRM Open Source
 * The Initial Developer of the Original Code is SugarCRM, Inc.
 * Portions created by SugarCRM are Copyright (C) 2004-2006 SugarCRM, Inc.;
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
 ********************************************************************************/
/*********************************************************************************

 * Description:
 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc. All Rights
 * Reserved. Contributor(s): ______________________________________..
 * *******************************************************************************/

require_once('XTemplate/xtpl.php');
require_once('modules/Translate/Translate.php');

global $app_strings;


$m 			= rawurldecode($_REQUEST['m']);
$lang 		= rawurldecode($_REQUEST['lang']);
$lbl 		= rawurldecode($_REQUEST['lbl']);
$str		= rawurldecode($_REQUEST['str']);

$results 	= array();

$translate = new Translate();


//Loop through valid modules and get valid entries for the given label
foreach($translate->modules as $mod)
{
	//Do not compare to the module being translated
	if($mod == $m)
		continue;	
	
	//Load current module and language file
	$tmp = new Translate($mod, $lang);
	
	
	/*
	 * Collect for suggestions based on current string
	 */
		
	//Include standard language file
	if($tmp->std_file)
	{
		//Initialize the mod_stings array
		$mod_strings 		= array();
		$app_strings 		= array();
		$app_list_strings 	= array();
		
		//Initialize collection array
		$results_str_lbls[$tmp->module] = array();
		
		//Include the standard language file
		include($tmp->std_file);
		
		//Set correct array, depending on availability of app_strings and app_list_strings
		$mod_strings = ($app_strings) ? $app_strings : $mod_strings;
		$mod_strings = array_merge($mod_strings, ($app_list_strings) ? $app_list_strings : array());
				
		//Loop through each lbl in mod_strings
		foreach($mod_strings as $label => $val)
		{
			/* If current string matches the one searched for
			 * add to array for results based on string
			 */
			
			//Check if val is dropdown
			if(is_array($val))
			{
				//Loop through dom
				foreach($val as $key => $value)
				{
					if($value == $str && !empty($value))
						$results_str_lbls[$tmp->module][] = $key;			
				}
			}
			else if($val == $str && !empty($val))
				$results_str_lbls[$tmp->module][] = $label;
		}
	}
	
	
	/*
	 * Search on suggestions based on current label 
	 */
		
	//Include language file
	if($tmp->lang_file)
	{
		//Initialize the xxx_strings arrays
		$mod_strings 		= array();
		$app_strings 		= array();
		$app_list_strings 	= array();
	
		//Include the language file
		include($tmp->lang_file);
		
		//Set correct array, depending on availability of app_strings and app_list_strings
		$mod_strings = ($app_strings) ? $app_strings : $mod_strings;
		$mod_strings = array_merge($mod_strings, ($app_list_strings) ? $app_list_strings : array());
		
		foreach($mod_strings as $label => $val)
		{
			//Check if val is dropdown
			if(is_array($val))
			{
				//Loop through dom
				foreach($val as $key => $value)
				{
					//Check if searched label matches current
					if($key == $lbl && !empty($value))
						$results[$tmp->module] = $value;

					
					//Check if current label is one of those collected, by string
					if(in_array($key, $results_str_lbls[$tmp->module]) && !empty($value))
						$results_str[$tmp->module][$key] = $value;
				}
			}
			else
			{ 
				//Check if searched label matches current			
				if($label == $lbl && !empty($val))
					$results[$tmp->module] = $val;
					
					
				//Check if current label is one of those colleted, by string
				if(in_array($label, $results_str_lbls[$tmp->module]) && !empty($val))
					$results_str[$tmp->module][$label] = $val;
			}
		}
	}
}

//Unset the mod_strings array
unset($mod_strings);


//Force inclusion of standard language file
include('include/language/en_us.lang.php');

//Force Translate language file into mod_strings
include('modules/Translate/language/en_us.lang.php');


//Initalize Template
$xtpl=new XTemplate ('modules/Translate/SearchSuggestions.html');
$xtpl->assign("MOD", 	$mod_strings);
$xtpl->assign("APP", 	$app_strings);

$xtpl->assign("LBL",	$lbl);


/*
 * Check for existing results based on label
 */
if(!empty($results))
{
	//Parse : By Label

	//Loop through each result based on label
	$i = 0;
	foreach($results as $r_mod => $r_val)
	{
		$xtpl->assign("TR_NR", 		$i);
		$xtpl->assign("TR_CLASS", 	($i++ % 2 == 0) ? 'norm'  : 'odd');
		$xtpl->assign("ROW_MODULE", $r_mod);
		$xtpl->assign("ROW_VALUE", 	$r_val);
		
		$xtpl->parse("main.lbl.row");	
	}
	
	//Parse whole label section
	$xtpl->parse("main.lbl");
}

/*
 * Check for existing results based on string
 */
if(!empty($results_str))
{
	//Loop through each module
	$i = 0;
	foreach($results_str as $module => $collections)
	{
		//Assign module
		$xtpl->assign("ROW_MODULE", $module);
	
		//Loop through each string found in current module
		$j = 0;
		foreach($collections as $rs_lbl => $rs_val)
		{
			$xtpl->assign("TR_NR", 		$i++.'_'.$j);
			$xtpl->assign("TR_CLASS", 	($j++ % 2 == 0) ? 'norm'  : 'odd');
			$xtpl->assign("ROW_LABEL", 	$rs_lbl);
			$xtpl->assign("ROW_VALUE",	$rs_val);
			
			//Parse current row
			$xtpl->parse("main.str.module.row");
		
		}
	
		//Parse module
		$xtpl->parse("main.str.module");
	}
	
	//Parse whole string section
	$xtpl->parse("main.str");
}

/*
 * No results found
 */
if(empty($results) && empty($results_str))
{
	$xtpl->parse("main.none_found");
}


$xtpl->parse("main");
$xtpl->out("main");
?>