<?php
require_once('data/SugarBean.php');
/* Redpill
 * Translate Class
 */
class Translate extends SugarBean {

	//Static
	var $module_path 	= 'modules/';
	var $language_path	= 'language/';
	var $archives_path	= 'archives/';
	var $common_path	= 'common/';
	var $std_lang		= 'en_us';
	
	//Variables
	var $modules 		= array();
	var $module		= false;
	var $std_file		= false;
	var $lang_file		= false;
	var $lang		= false;
	var $translation	= array();
	var $archives		= array();
	var $file		= false;
	var $next_module	= false;
	var $disable_vardefs	= true;
		
	/* Redpill AB
	 * Defined modules not to translate
	 */
	var $en_us_mods = array();
	
	
	/* Redpill
	 * Constuctor
	 */
	function Translate($module = false, $lang = false){

		//Read all valid modules
		$this->read_valid_modules();
				
		//Set valid module
		$this->module = (empty($module)) ? $this->modules[0] : $module;
		
		//Set valid language
		$this->lang = (empty($lang)) ? false : $lang;
				
		//Special cases
		$this->translate_special_cases($module, $lang);
				
		//Set standard language file
		if(isset($this->module) && !empty($this->module))
			$this->std_file = $this->module_path.$this->module."/".$this->language_path.$this->std_lang.".lang.php";
					
		//Set foreign language file
		if(isset($lang) && !empty($lang) && file_exists($this->module_path.$this->module."/".$this->language_path.$lang.".lang.php"))
			$this->lang_file = $this->module_path.$this->module."/".$this->language_path.$lang.".lang.php";
			
		//Read already created archives
		$this->readArchives();
		
		if(isset($_REQUEST['next_module']) && $_REQUEST['next_module'] == 'true') {
			$this->next_module = true;
		}
	}
	
	/* Redpill
	 * Set path for special cases
	 */
	function translate_special_cases($module = false, $lang = false){
		//Special case : Global language file
		if($this->module == 'Global' || $this->module == 'include'){
			$this->module_path	= '';
			$this->module 		= 'include';
		}

		//Special case : SugarObjects/implements/assignable language file
		if($this->module == 'Assignable' || $this->module == 'include/SugarObjects/implements/assignable'){
			$this->module_path	= '';
			$this->module 		= 'include/SugarObjects/implements/assignable';
		}

		//Special case : SugarObjects/implements/team_security language file
		if($this->module == 'Team Security' || $this->module == 'include/SugarObjects/implements/team_security'){
			$this->module_path	= '';
			$this->module 		= 'include/SugarObjects/implements/team_security';
		}

		//Special case : SugarObjects/templates/basic language file
		if($this->module == 'Basic' || $this->module == 'include/SugarObjects/templates/basic'){
			$this->module_path	= '';
			$this->module 		= 'include/SugarObjects/templates/basic';
		}

		//Special case : SugarObjects/templates/company language file
		if($this->module == 'Company' || $this->module == 'include/SugarObjects/templates/company'){
			$this->module_path	= '';
			$this->module 		= 'include/SugarObjects/templates/company';
		}

		//Special case : SugarObjects/templates/company language file
		if($this->module == 'File' || $this->module == 'include/SugarObjects/templates/file'){
			$this->module_path	= '';
			$this->module 		= 'include/SugarObjects/templates/file';
		}

		//Special case : SugarObjects/templates/issue language file
		if($this->module == 'Issue' || $this->module == 'include/SugarObjects/templates/issue'){
			$this->module_path	= '';
			$this->module 		= 'include/SugarObjects/templates/issue';
		}

		//Special case : SugarObjects/templates/person language file
		if($this->module == 'Person' || $this->module == 'include/SugarObjects/templates/person'){
			$this->module_path	= '';
			$this->module 		= 'include/SugarObjects/templates/person';
		}

		//Special case : SugarObjects/templates/person language file
		if($this->module == 'Sale' || $this->module == 'include/SugarObjects/templates/sale'){
			$this->module_path	= '';
			$this->module 		= 'include/SugarObjects/templates/sale';
		}

		//Special case : SugarObjects/templates/person language file
		if($this->module == 'Install' || $this->module == 'install'){
			$this->module_path	= '';
			$this->module 		= 'install';
		}

		//Special case : SugarObjects/templates/person language file
		if($this->module == 'Portal' || $this->module == 'portal/include'){
			$this->module_path	= '';
			$this->module 		= 'portal/include';
		}

		//Special case : SugarObjects/templates/person language file
		if($this->module == 'FAQ' || $this->module == 'portal/modules/FAQ'){
			$this->module_path	= '';
			$this->module 		= 'portal/modules/FAQ';
		}

	}
	
	/* Redpill
	 * Read all modules and store valid ones $modules array
	 */
	function read_valid_modules(){
		//Read the modules directory
		if(!$dir = opendir($this->module_path))
			die(error_log("Error: Could not open module path. Exiting."));
				
		//Loop through all files / directories
		while(($module = readdir($dir)) !== false){

			//Check if is directory, and that standard language file is present 
			if(is_dir($this->module_path."/".$module) && !in_array($module, $this->en_us_mods)
			&& file_exists($this->module_path.$module."/".$this->language_path.$this->std_lang.".lang.php")){
				//Add file to valid modules list
				$this->modules[] = $module;
			}
		}
		
		//Add special cases: SugarObjects
		$this->modules[] = 'Person';
		$this->modules[] = 'Assignable';
		$this->modules[] = 'Team Security';
		$this->modules[] = 'Basic';
		$this->modules[] = 'Company';
		$this->modules[] = 'Issue';
		$this->modules[] = 'File';
		$this->modules[] = 'Sale';
		$this->modules[] = 'Issue';
		$this->modules[] = 'File';
		$this->modules[] = 'Sale';
		$this->modules[] = 'Portal';
		$this->modules[] = 'FAQ';
		$this->modules[] = 'Install';

		//Sort the modules in alphabetical order
		sort($this->modules);
				
		//Place the Global module on top of the list
		array_unshift($this->modules, 'Global');
	}
	
	
	/* Redpill
	 * Set the language file for the current module
	 */
	function set_language_file(){
		if(!empty($this->lang) && !empty($this->module)){
			$this->lang_file = $this->module_path.$this->module."/".$this->language_path.$this->lang.".lang.php";
		}else{
			die(error_log("Error: Could not set language file. Aborting."));
		}
	}
		
	/* Redpill
	 * Write translated labels / dropdowns to file
	 */
	function save(){

		//Generate file content string
		$content_header =
"<?php\n"
."if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');\n"
."/*********************************************************************************\n"
."* The contents of this file are subject to the SugarCRM Public License Version\n"
." * 1.1.3 (\"License\"); You may not use this file except in compliance with the\n"
." * License. You may obtain a copy of the License at http://www.sugarcrm.com/SPL\n"
." * Software distributed under the License is distributed on an \"AS IS\" basis,\n"
." * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License\n"
." * for the specific language governing rights and limitations under the\n"
." * License.\n"
." *\n"
." * All copies of the Covered Code must include on each user interface screen:\n"
." *    (i) the \"Powered by SugarCRM\" logo and\n"
." *    (ii) the SugarCRM copyright notice\n"
." * in the same form as they appear in the distribution.  See full license for\n"
." * requirements.\n"
." *\n"
." * The Original Code is: SugarCRM Open Source\n"
." * The Initial Developer of the Original Code is SugarCRM, Inc.\n"
." * Portions created by SugarCRM are Copyright (C) 2004-2006 SugarCRM, Inc.;\n"
." * All Rights Reserved.\n"
." * Contributor(s): ______________________________________.\n"
." ********************************************************************************/\n"
."\n"
."/*********************************************************************************\n"
." * Description:  Defines the English language pack for the base application.\n"
." * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.\n"
." * All Rights Reserved.\n"
." * Contributor(s): ______________________________________..\n"
." ********************************************************************************/\n"
."\n"
.(($this->module == 'include') ? '$app_strings' : '$mod_strings') .'= array ('."\n";

		$content_footer = "?>\n";
		
		//Set labels
		if(!empty($this->translation)){
			foreach($this->translation as $lbl => $val){
				if(is_array($val)){
					//Dropdown
				
					//Add dom-name
					$content_body .= "\n\n'$lbl' => array(\n";
					
					//Add each option
					foreach($val as $key => $value)
						$content_body .= str_pad("'$key'", 50)." => '".$this->escape($value)."',\n";
					
					$content_body .= "),\n";
				
				}else{
					//Normal label
					$content_body .= str_pad("'$lbl'", 50)." => '".$this->escape($val)."',\n";
				}
			}
		}
		
		//Always enclose the first language array
		$content_body .= ');';
		
		//Set doms
		if(!empty($this->doms)){
			
			$content_body .= '$app_list_strings = array ('."\n";
			
			foreach($this->doms as $lbl => $val){
				if(is_array($val)){
					//Dropdown
				
					//Add dom-name
					$content_body .= "\n\n'$lbl' => array(\n";
					
					//Add each option
					foreach($val as $key => $value)
						$content_body .= str_pad("'$key'", 50)." => '".$this->escape($value)."',\n";
					
					$content_body .= "),\n";
				
				}else{
					//Normal label
					$content_body .= str_pad("'$lbl'", 50)." => '".$this->escape($val)."',\n";
				}
			}
			$content_body .= ');';
		}
		
		//Build file content
		$file_content = $content_header.$content_body.$content_footer;
		
		//Write to file
		if(!file_put_contents($this->lang_file, $file_content)) {
			die(error_log("Error: Could not write content to file. Aborting."));
		}

		$location = "index.php?module=Translate&action=index&m=$this->module&lang=$this->lang";
		$location.= ($this->next_module) ? "&next_module=true" : '';
		
		header("Location: $location");
	}
		
	/* Redpill AB
	 * Descape given string
	 */
	function descape($str){
		return htmlspecialchars($str, ENT_QUOTES);
	}
		
	/* Redpill AB
	 * Escape given string
	 */
	function escape($str){
		$str = str_replace('\"', '"', $str);	
			
		return str_replace('\'', '\'', $str);
	}
		
	/* Redpill AB
	 * Create Language Pack zip-archive
	 */
	function createLangPack($filename, $lp_params){
		//Instansiate ZipArchive object
		$zip = new ZipArchive();
		
		//Open ZipArchive file
		if($zip->open('modules/Translate/'.$this->archives_path.$filename, ZIPARCHIVE::OVERWRITE) !== true)
			die(error_log("Error: Could not create zip-archive. Please check permissions and try again. Aborting."));
					
		//Add all available language files for current language to zip-archive
		foreach($this->modules as $module){
			//Skip excluded modules
			if(in_array($module, $this->en_us_mods))
				continue;
		
			//Set basic path for current module
			switch ($module){
				case 'Global':
					$path = 'include/';
					break;
				case 'Assignable':
					$path = 'include/SugarObjects/implements/assignable/';
					break;
				case 'Team Security':
					$path = 'include/SugarObjects/implements/team_security/';
					break;
				case 'Basic':
					$path = 'include/SugarObjects/templates/basic/';
					break;
				case 'Company':
					$path = 'include/SugarObjects/templates/company/';
					break;
				case 'Issue':
					$path = 'include/SugarObjects/templates/issue/';
					break;
				case 'Person':
					$path = 'include/SugarObjects/templates/person/';
					break;
				case 'File':
					$path = 'include/SugarObjects/templates/file/';
					break;
				case 'Sale':
					$path = 'include/SugarObjects/templates/sale/';
					break;
				case 'Portal':
					$path = 'portal/include/';
					break;
				case 'FAQ':
					$path = 'portal/modules/FAQ/';
					break;
				case 'Install':
					$path = 'install/';
					break;
				default:
					$path = 'modules/'.$module.'/';
					break;
			}

			//Create path to current language file
			$lang_file = $path.$this->language_path.$this->lang.'.lang.php';
			
			//If file exists, add to zip-archive
			if(file_exists($lang_file))
				$zip->addFile($lang_file);
		}
		
		//Create manifest.php from template. ($manifest_inc)
		include($this->module_path.'Translate/'.$this->common_path.'manifest.inc.php');

		//Add jscalendar
		if(file_exists('jscalendar/lang/calendar-' . $this->lang . '.js')){
			$zip->addFile('jscalendar/lang/calendar-' . $this->lang . '.js', 'jscalendar/lang/calendar-' . $this->lang . '.js');
		}else{
			$zip->addFile('jscalendar/lang/calendar-en.js', 'jscalendar/lang/calendar-' . $this->lang . '.js');
		}

		//Add address fields
		if(file_exists('include/SugarFields/Fields/Address/' . $this->lang . '.DetailView.tpl')){
			$zip->addFile('include/SugarFields/Fields/Address/' . $this->lang . '.DetailView.tpl', 'include/SugarFields/Fields/Address/' . $this->lang . '.DetailView.tpl');
		}
		if(file_exists('include/SugarFields/Fields/Address/' . $this->lang . '.EditView.tpl')){
			$zip->addFile('include/SugarFields/Fields/Address/' . $this->lang . '.EditView.tpl', 'include/SugarFields/Fields/Address/' . $this->lang . '.EditView.tpl');
		}

		//Create manifest.php, from string
		$zip->addFromString('manifest.php', $manifest_inc);
		
		//Close zip-archive
		$zip->close();

		//Redirect to page listing all created archives
		header("Location: index.php?module=Translate&action=index&m=$this->module&lang=$this->lang&auto_update=".$_REQUEST['auto_update']."show_archives=1");
		die();
	}
		
	/* Redpill AB
	 * Read already created archives
	 */
	function readArchives(){
		//Open dir
		$dh = opendir('modules/Translate/'.$this->archives_path);
		
		//Read dir, and chech for already created archives
		while(false !== ($file = readdir($dh))){

			//Create full file path
			$file_path = 'modules/Translate/'.$this->archives_path.$file;
			
			if(is_file($file_path)){				 
				$this->archives[] = $this->readZip($file_path, $file);
			}
		}				
	}



	function readZip($file_path, $file){
		$zip_handle = zip_open($file_path);
		
		if($zip_handle){
			while($zip_entry = zip_read($zip_handle)){
				if(zip_entry_name($zip_entry) == 'manifest.php'){
					if ($a = zip_entry_read($zip_entry, 10000)){
						$a = eval(str_replace("<?php", "", $a));
						$a = eval(str_replace("?>", "", $a));
						return array('file' => $file,
							     'link' => $file_path,
							     'name' => $manifest['name'],
							     'version' => $manifest['version'],
							     'author' => $manifest['author'],
							     'published_date' => $manifest['published_date'],
							     'description' => $manifest['description']);
						
					}
				}
			}
			zip_close($zip_handle);
		}
	}
}

?>
