<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*********************************************************************************
 * The contents of this file are subject to the SugarCRM Public License Version
 * 1.1.3 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.sugarcrm.com/SPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by SugarCRM" logo and
 *    (ii) the SugarCRM copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: SugarCRM Open Source
 * The Initial Developer of the Original Code is SugarCRM, Inc.
 * Portions created by SugarCRM are Copyright (C) 2004-2006 SugarCRM, Inc.;
 * All Rights Reserved.
 ********************************************************************************/
/*********************************************************************************
 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.
 * All Rights Reserved.
 ********************************************************************************/

require_once('XTemplate/xtpl.php');
require_once('modules/Translate/Translate.php');

global $timedate;
global $mod_strings;
global $app_strings;
global $app_list_strings;
global $gridline;
global $theme;
global $current_user;

if(! is_admin($current_user)) {
	sugar_die($mod_strings['LBL_NO_ACCESS']);
}

/* Redpill
 * Get all variables
 */
$m 		= (isset($_REQUEST['m'])) ? $_REQUEST['m'] : '';
$lang		= (isset($_REQUEST['lang'])) ? $_REQUEST['lang'] : '';
$auto_update	= (isset($_REQUEST['auto_update'])) ? $_REQUEST['auto_update'] : '';

if(isset($_REQUEST['next_module'])) {
	$translate = new Translate();
	$modules = $translate->modules;
	$index = array_search($m, $modules);
	
	if($index < count($modules) - 1) {
		$m = $modules[++$index];
	}
}

$std 		= array();
$dom		= array();
$foreign	= array();


/* Redpill
 * Load selected module, if any selected
 */
$page = new Translate($m, $lang);

//Check for standard language file en_us
if($page->std_file){
	include($page->std_file);
	
	//Special case : Global
	if($page->module == 'include'){
		$std = $app_strings;
		$dom = $app_list_strings;
	}else{
		$std = $mod_strings;
	}	
	unset($mod_strings);
}

//Foreign language
if($page->lang_file){
	include($page->lang_file);
	
	//Special case : Global
	if($page->module == 'include'){
		$foreign 	= $app_strings;
		$foreign_dom 	= $app_list_strings;
	}else{
		$foreign = $mod_strings;
	}
	unset($mod_strings);
}

/* Redpill
 * Force the original langauage file back into array
 */
include('modules/Translate/language/en_us.lang.php');
include('include/language/en_us.lang.php');

$theme_path	= "themes/".$theme."/";
$image_path	= $theme_path."images/";
$default_path	= "themes/default/images/";

$xtpl=new XTemplate ('modules/Translate/Main.html');
$xtpl->assign("MOD", $mod_strings);
$xtpl->assign("APP", $app_strings);

$xtpl->assign("THEME", $theme);
$xtpl->assign("GRIDLINE", $gridline);
$xtpl->assign("IMAGE_PATH", $image_path);
$xtpl->assign("DEFAULT_IMAGE_PATH", $default_path);

//Language
$xtpl->assign("LANG", $lang);

//Auto Update: Checkbox
if($auto_update == 'on')
	$xtpl->assign("CHECKED", "checked");

//Auto Update: Hidden value in forms
$xtpl->assign("AUTO_UPDATE", $auto_update);

//Available archives
foreach($page->archives AS $archive){
	$xtpl->assign("ARCHIVE_FILE", $archive['file']);
	$xtpl->assign("ARCHIVE_LINK", $archive['link']);
	$xtpl->assign("ARCHIVE_NAME", $archive['name']);
	$xtpl->assign("ARCHIVE_VERSION", $archive['version']);
	$xtpl->assign("ARCHIVE_AUTHOR", $archive['author']);
	$xtpl->assign("ARCHIVE_PUBLISHED_DATE", $archive['published_date']);
	$xtpl->assign("ARCHIVE_DESCRIPTION", $archive['description']);
	$xtpl->parse("main.archive");
}

$xtpl->assign("ARCHIVES", $page->archives);

if(!empty($lang)){
	$total_entries = 0;
	$empty_entries = 0;

	//Show current module
	$xtpl->assign("MODULE",	$page->module);

	//Show pregenerated filenanme, for Create Language Pack
	$filename = $lang.'_lang-'.date('Y-m-d');
	$xtpl->assign("FILENAME", $filename);

	//Show the possibility to create language pack
	$xtpl->parse("main.create_lang_pack");
	$xtpl->parse("main.create_lang_pack_form");
	
	/* Redpill
	 * Load selected module, if any selected
	 */
	foreach($std as $lbl => $value){
		if(!is_array($value)){
			$total_entries++;
			$empty_entries+= (isset($foreign[$lbl]) && $foreign[$lbl] != '') ? 0 : 1;

			//Normal Label
			$xtpl->assign("LBL", (!empty($lbl) ? $lbl : '&nbsp;'));
			$xtpl->assign("STD_VALUE", $page->descape($value));
			$xtpl->assign("FOREIGN_VALUE", (isset($foreign[$lbl])) ? $foreign[$lbl] : '');
			$xtpl->parse("main.translate.row");
		}else{
			//Dropdown or similar
			$xtpl->assign("DROPDOWN", $lbl);

			//Loop trough each dropdown-option
			foreach($value as $key => $val){
				$total_entries++;
				$empty_entries+= (isset($foreign[$lbl][$key]) && $foreign[$lbl][$key] != '') ? 0 : 1;

				$xtpl->assign("LBL", (!empty($key) ? $key : '&nbsp;'));
				$xtpl->assign("STD_VALUE", $page->descape($val));
				$xtpl->assign("FOREIGN_VALUE", (isset($foreign[$lbl][$key])) ? $foreign[$lbl][$key] : '');
				$xtpl->parse("main.translate.dropdown.row");
			}
			$xtpl->parse("main.translate.dropdown");
		}
	}
	
	//Display all doms in global language file, if currently translated
	foreach($dom as $lbl => $value){
		if(!is_array($value)){
			$total_entries++;
			$empty_entries+= (isset($foreign_dom[$lbl]) && $foreign_dom[$lbl] != '') ? 0 : 1;

			//Normal Label
			$xtpl->assign("LBL", (!empty($lbl) ? $lbl : '&nbsp;'));
			$xtpl->assign("STD_VALUE", $page->descape($value));
			$xtpl->assign("FOREIGN_VALUE", (isset($foreign_dom[$lbl])) ? $foreign_dom[$lbl] : '');
			$xtpl->parse("main.translate.dom.row");
		}else{
			//Dropdown or similar
			$xtpl->assign("DROPDOWN", $lbl);
			//Loop trough each dropdown-option
			foreach($value as $key => $val){
				$total_entries++;
				$empty_entries+= (isset($foreign_dom[$lbl][$key]) && $foreign_dom[$lbl][$key] != '') ? 0 : 1;

				$xtpl->assign("LBL", (!empty($key) ? $key : '&nbsp;'));
				$xtpl->assign("STD_VALUE", $page->descape($val));
				$xtpl->assign("FOREIGN_VALUE", (isset($foreign_dom[$lbl][$key])) ? $foreign_dom[$lbl][$key] : '');
				$xtpl->parse("main.translate.dom.dropdown.row");
			}			
			$xtpl->parse("main.translate.dom.dropdown");
		}
		$xtpl->parse("main.translate.dom");
	}
	//Show current module
	$xtpl->assign("MODULE_NAME",	$page->module . ': ' . $empty_entries . ' / ' . $total_entries);

	$xtpl->parse("main.translate");
}else{
	$xtpl->parse("main.none_selected");
}

$xtpl->parse("main");
$xtpl->out("main");
?>
