/* Redpill AB
 * Global variables to keep track of mouse pointer position
 */
var posx = 0;
var posy = 0;

function moveToNextEmpty() {
	var elements = document.getElementsByTagName('textarea');
	var hasEmpty = false;
	
	for(el in elements) {
		if(elements[el] && elements[el].name && elements[el].name.substr(0, 5) == 'label' && elements[el].value == '') {
			elements[el].focus();
			hasEmpty = true;
			break;
		}
	}
}

/* Redpill
 * Copy value from the std-language to the translation text-field
 */
function copyValue(lbl)
{
	var std = document.getElementById('std[' + lbl + ']').value;
	var oth = document.getElementById('label[' + lbl + ']');
	
	//Set value in new input text field
	oth.value = std;
}


/* Redpill
 * Toggle the visibilty of a div, with BlindUp/Down
 */
function toggleView(id)
{
	obj = document.getElementById(id);
	
	if(obj.style.display == 'none')
		effect = new Effect.BlindDown(obj);
	else
		effect = new Effect.BlindUp(obj);	
}


/* Redpill
 * Toggle the visibility of a div
 */
function toggleAppear(id)
{
	obj = document.getElementById(id);
	
	
	//Just show
	if(obj.style.display == 'none')
		obj.style.display = 'block';
	else
		obj.style.display = 'none';
	
	//Fade	
	/*if(obj.style.display == 'none')
		effect = new Effect.Appear(obj);
	else
		effect = new Effect.Fade(obj);
	*/	
}

/* Redpill
 * Check that a valid language file prefix has been entered, before saving settings
 */
function checkSettings()
{
	var lang = document.getElementById('settings_lang').value;
	
	if(lang == '')
	{
		setBGColor('settings_lang', '#ff7f7f');
		return false;
	}
	else
	{
		return true;		
	}
}

/* Redpill
 * Set specified background color on given object id
 */
function setBGColor(id, color)
{
	obj = document.getElementById(id);
	
	obj.style.backgroundColor = color;	
}


/* Redpill
 * Search for suggestions to translate the specified label
 */
function searchSuggestions(lbl, str)
{
	var m 		= document.getElementById('m').value;
	var lang 	= document.getElementById('lang').value;
	
	
	//Blind down suggestion div
	//toggleAppear('backgr');
	$('suggestions').show();
	displayLoad();
	
			
	if(m != '' && lang != '' && lbl != '')
	{
		//Build url
		var url		= 'index.php?'
					+ 'module=Translate'
					+ '&action=SearchSuggestions'
					+ '&sugar_body_only=1'
					+ '&m=' 	+ escape(m)
					+ '&lang=' 	+ escape(lang)
					+ '&lbl=' 	+ escape(lbl)
					+ '&str=' 	+ escape(str);
		
		//Make Ajax-request
		new Ajax.Updater('suggestions', url, { method: 'get' });
	}
}


/* Redpill
 * Displays loading window, before suggestions have been returned from server
 */
function displayLoad()
{
	div = document.getElementById('suggestions');
	
	div.innerHTML = '<table height="100%" width="100%">'
				  +	'<tr>'
				  + '<td height="5" align="right" valign="top">'
				  + '<a href="javascript:closeSuggestions()"><img src="themes/Sugar/images/close.gif" border="0"></a>'
				  + '</td>'
				  + '</tr><tr>'
				  + '<td align="center" valign="middle">'
				  + '<img src="themes/default/images/loading.gif">'
				  + '&nbsp;<b>Loading...</b>'
				  + '</td>'
				  + '</tr>'
				  + '</table>';
}


/* Redpill
 * Close the suggestions div
 */
function closeSuggestions()
{
	$('suggestions').hide();
	//toggleAppear('backgr');	
}


/* Redpill
 * Set onmouseover effects on tr
 */
function setHoverTr(tr)
{
	//Set the cursor, indicating a selectable object
	document.body.style.cursor='pointer';
	document.body.style.cursor='hand';
	
	//Set new background color on tr when mouse hovers object
	
	//Add the normal classes
	$(tr).removeClassName('norm');
	$(tr).removeClassName('odd');
	
	//Add the highlight class
	$(tr).addClassName('highlight');
}


/* Redpill
 * Reset effects when mouse cursor leaves the tr
 */
function setNormalTr(tr, style)
{
	//Change the mouse cursor back to normal arrow
	document.body.style.cursor='auto';
	
	
	//Remove the hightlight class
	$(tr).removeClassName('highlight');
	
	//Add the class, displaying the normal tr
	$(tr).addClassName(style);
}


/* Redpill
 * Set value val in field lbl
 */
function setValue(lbl, val)
{
	var field = document.getElementById('label[' + lbl + ']');
	
	//Close the suggestions div
	closeSuggestions();
	
	//Set new value in field
	field.value = val;
}


/* Redpill
 * Set opacity on object
 */
function setOp(obj, opacity)
{
	
	//css
	obj.style.opacity	= opacity;
	
	//IE-fix
	obj.style.filter	= 'alpha(opacity=' + opacity +')'; 
}

/* Redpill AB
 * Update suggestions with current label and string
 */
function updateSuggestions(lbl)
{
	if($('auto_update').checked && $('suggestions').style.display != 'none')
		searchSuggestions(lbl);
	
}


/* Redpill AB
 * Check all parameters before creating a lanuage pack
 */
function checkCreateLangPack()
{
	var lp_filename	= $('filename').value;
	var lp_version  = $('lang_pack_version').value;
	var lp_date  	= $('lang_pack_date').value;	
	var lp_author 	= $('lang_pack_author').value;		
	var lp_name		= $('lang_pack_name').value;
	var lp_desc		= $('lang_pack_desc').value;
	
	if(lp_filename == '' || lp_date == '' || lp_author == '' || lp_version == '' || lp_name == '' || lp_desc == '')
	{
		alert('Please, enter values in all fields before creating the lanuage pack');
		return false;	
	}
	else
		return true;
}
