<?php
if(!defined('sugarEntry'))define('sugarEntry', true);

/*********************************************************************************
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2012 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/

function add_new_iframe_dashlets(){
	$hasDiscoverSugarPro = false;
	$hasSugarNews = false;
	$newDashlets = array();
	$newIds = array();
	require_once('cache/dashlets/dashlets.php');	
    $discoverSugarProDashlet = array('className' => 'iFrameDashlet',
         'module' => 'iFrames',
         'fileLocation' => $dashletsFiles['iFrameDashlet']['file'],
         'options' => array('title' => translate('LBL_DASHLET_DISCOVER_SUGAR_PRO','iFrames'),
        'url' => 'http://apps.sugarcrm.com/dashlet/5.2.0/go-pro.html?lang=@@LANG@@&edition=@@EDITION@@&ver=@@VER@@',
        'height' => 315,
     ));
    $sugarNewsDashlet = array('className' => 'iFrameDashlet',
					 'module' => 'iFrames',
					 'fileLocation' => $dashletsFiles['iFrameDashlet']['file'],
					 'options' => array('title' => translate('LBL_DASHLET_SUGAR_NEWS','iFrames'),
                    'url' => 'http://apps.sugarcrm.com/dashlet/5.2.0/sugarcrm-news-dashlet.html?lang=@@LANG@@&edition=@@EDITION@@&ver=@@VER@@',
                    'height' => 315,
     ));
     
	$db = &PearDatabase::getInstance();
	$query = "SELECT id, contents, assigned_user_id FROM user_preferences WHERE deleted = 0 AND category = 'Home'";
	$result = $db->query($query, true, "Unable to update new default dashlets! ");
	while ($row = $db->fetchByAssoc($result)) {
		$content = unserialize(base64_decode($row['contents']));
		$assigned_user_id = $row['assigned_user_id'];
		$record_id = $row['id'];
		
		$current_user = new User();
        $current_user->retrieve($row['assigned_user_id']);
        
		if(!empty($content['dashlets']) && !empty($content['pages'])){
			$originalDashlets = $content['dashlets'];
			$originalPages = $content['pages'];
			//Determine if the original perference has already had the two dashlets or not
			foreach($originalDashlets as $ds){
				if(!empty($ds['options']['title']) && $ds['options']['title'] == translate('LBL_DASHLET_DISCOVER_SUGAR_PRO','iFrames')){
					$hasDiscoverSugarPro = true;
				}
				if(!empty($ds['options']['title']) && $ds['options']['title'] == translate('LBL_DASHLET_SUGAR_NEWS','iFrames')){
					$hasSugarNews = true;
				}
			}
			
			//If the user_perference has no 'Sugar News' dashlet and no 'Discover sugar Pro' dashlet, we should add them 
			if(!$hasSugarNews && !$hasDiscoverSugarPro){
    			$discoverSugarProDashletId = create_guid();
				$newDashlets["$discoverSugarProDashletId"]  = $discoverSugarProDashlet;
				$sugarNewsId = create_guid();
				$newDashlets["$sugarNewsId"]  = $sugarNewsDashlet;
				$originalDashlets = array_merge_recursive($newDashlets, $originalDashlets );
				if( !empty($originalPages[0]['numColumns']) && !empty($originalPages[0]['columns']) ){
					switch($originalPages[0]['numColumns']){
						case '1':
							if(!empty($originalPages[0]['columns'][0]['dashlets'])){
								array_unshift($originalPages[0]['columns'][0]['dashlets'] , $sugarNewsId);
								array_unshift( $originalPages[0]['columns'][0]['dashlets'] , $discoverSugarProDashletId);
							}
							break;
						case '2':
						case '3':
							if(!empty($originalPages[0]['columns'][0]['dashlets'])){
								array_unshift( $originalPages[0]['columns'][0]['dashlets'] , $discoverSugarProDashletId);
							}
							if(!empty($originalPages[0]['columns'][1]['dashlets'])){
								array_unshift($originalPages[0]['columns'][1]['dashlets'] , $sugarNewsId);
							}
					}
				}
			}
			$current_user->setPreference('dashlets', $originalDashlets, 0, 'Home');
			$current_user->setPreference('pages', $originalPages, 0, 'Home');	
		}
	}
}
?>
