/*
 Copyright (c) 2010, Yahoo! Inc. All rights reserved.
 Code licensed under the BSD License:
 http://developer.yahoo.com/yui/license.html
 version: 3.3.0
 build: 3167
 */
YUI.add('transition-native',function(Y){var TRANSITION='-webkit-transition',TRANSITION_CAMEL='WebkitTransition',TRANSITION_PROPERTY_CAMEL='WebkitTransitionProperty',TRANSITION_PROPERTY='-webkit-transition-property',TRANSITION_DURATION='-webkit-transition-duration',TRANSITION_TIMING_FUNCTION='-webkit-transition-timing-function',TRANSITION_DELAY='-webkit-transition-delay',TRANSITION_END='webkitTransitionEnd',ON_TRANSITION_END='onwebkittransitionend',TRANSFORM_CAMEL='WebkitTransform',EMPTY_OBJ={},Transition=function(){this.init.apply(this,arguments);};Transition.fx={};Transition.toggles={};Transition._hasEnd={};Transition._toCamel=function(property){property=property.replace(/-([a-z])/gi,function(m0,m1){return m1.toUpperCase();});return property;};Transition._toHyphen=function(property){property=property.replace(/([A-Z]?)([a-z]+)([A-Z]?)/g,function(m0,m1,m2,m3){var str='';if(m1){str+='-'+m1.toLowerCase();}
str+=m2;if(m3){str+='-'+m3.toLowerCase();}
return str;});return property;};Transition._reKeywords=/^(?:node|duration|iterations|easing|delay|on|onstart|onend)$/i;Transition.useNative=false;if(TRANSITION in Y.config.doc.documentElement.style){Transition.useNative=true;Transition.supported=true;}
Y.Node.DOM_EVENTS[TRANSITION_END]=1;Transition.NAME='transition';Transition.DEFAULT_EASING='ease';Transition.DEFAULT_DURATION=0.5;Transition.DEFAULT_DELAY=0;Transition._nodeAttrs={};Transition.prototype={constructor:Transition,init:function(node,config){var anim=this;anim._node=node;if(!anim._running&&config){anim._config=config;node._transition=anim;anim._duration=('duration'in config)?config.duration:anim.constructor.DEFAULT_DURATION;anim._delay=('delay'in config)?config.delay:anim.constructor.DEFAULT_DELAY;anim._easing=config.easing||anim.constructor.DEFAULT_EASING;anim._count=0;anim._running=false;}
return anim;},addProperty:function(prop,config){var anim=this,node=this._node,uid=Y.stamp(node),nodeInstance=Y.one(node),attrs=Transition._nodeAttrs[uid],computed,compareVal,dur,attr,val;if(!attrs){attrs=Transition._nodeAttrs[uid]={};}
attr=attrs[prop];if(config&&config.value!==undefined){val=config.value;}else if(config!==undefined){val=config;config=EMPTY_OBJ;}
if(typeof val==='function'){val=val.call(nodeInstance,nodeInstance);}
if(attr&&attr.transition){if(attr.transition!==anim){attr.transition._count--;}}
anim._count++;dur=((typeof config.duration!='undefined')?config.duration:anim._duration)||0.0001;attrs[prop]={value:val,duration:dur,delay:(typeof config.delay!='undefined')?config.delay:anim._delay,easing:config.easing||anim._easing,transition:anim};computed=Y.DOM.getComputedStyle(node,prop);compareVal=(typeof val==='string')?computed:parseFloat(computed);if(Transition.useNative&&compareVal===val){setTimeout(function(){anim._onNativeEnd.call(node,{propertyName:prop,elapsedTime:dur});},dur*1000);}},removeProperty:function(prop){var anim=this,attrs=Transition._nodeAttrs[Y.stamp(anim._node)];if(attrs&&attrs[prop]){delete attrs[prop];anim._count--;}},initAttrs:function(config){var attr,node=this._node;if(config.transform&&!config[TRANSFORM_CAMEL]){config[TRANSFORM_CAMEL]=config.transform;delete config.transform;}
for(attr in config){if(config.hasOwnProperty(attr)&&!Transition._reKeywords.test(attr)){this.addProperty(attr,config[attr]);if(node.style[attr]===''){Y.DOM.setStyle(node,attr,Y.DOM.getComputedStyle(node,attr));}}}},run:function(callback){var anim=this,node=anim._node,config=anim._config,data={type:'transition:start',config:config};if(!anim._running){anim._running=true;if(config.on&&config.on.start){config.on.start.call(Y.one(node),data);}
anim.initAttrs(anim._config);anim._callback=callback;anim._start();}
return anim;},_start:function(){this._runNative();},_prepDur:function(dur){dur=parseFloat(dur);return dur+'s';},_runNative:function(time){var anim=this,node=anim._node,uid=Y.stamp(node),style=node.style,computed=getComputedStyle(node),attrs=Transition._nodeAttrs[uid],cssText='',cssTransition=computed[TRANSITION_PROPERTY],transitionText=TRANSITION_PROPERTY+': ',duration=TRANSITION_DURATION+': ',easing=TRANSITION_TIMING_FUNCTION+': ',delay=TRANSITION_DELAY+': ',hyphy,attr,name;if(cssTransition!=='all'){transitionText+=cssTransition+',';duration+=computed[TRANSITION_DURATION]+',';easing+=computed[TRANSITION_TIMING_FUNCTION]+',';delay+=computed[TRANSITION_DELAY]+',';}
for(name in attrs){hyphy=Transition._toHyphen(name);attr=attrs[name];if(attrs.hasOwnProperty(name)&&attr.transition===anim){if(name in node.style){duration+=anim._prepDur(attr.duration)+',';delay+=anim._prepDur(attr.delay)+',';easing+=(attr.easing)+',';transitionText+=hyphy+',';cssText+=hyphy+': '+attr.value+'; ';}else{this.removeProperty(name);}}}
transitionText=transitionText.replace(/,$/,';');duration=duration.replace(/,$/,';');easing=easing.replace(/,$/,';');delay=delay.replace(/,$/,';');if(!Transition._hasEnd[uid]){node.addEventListener(TRANSITION_END,anim._onNativeEnd,false);Transition._hasEnd[uid]=true;}
style.cssText+=transitionText+duration+easing+delay+cssText;},_end:function(elapsed){var anim=this,node=anim._node,callback=anim._callback,config=anim._config,data={type:'transition:end',config:config,elapsedTime:elapsed},nodeInstance=Y.one(node);anim._running=false;anim._callback=null;if(node){if(config.on&&config.on.end){setTimeout(function(){config.on.end.call(nodeInstance,data);if(callback){callback.call(nodeInstance,data);}},1);}else if(callback){setTimeout(function(){callback.call(nodeInstance,data);},1);}}},_endNative:function(name){var node=this._node,value=node.ownerDocument.defaultView.getComputedStyle(node,'')[TRANSITION_PROPERTY];if(typeof value==='string'){value=value.replace(new RegExp('(?:^|,\\s)'+name+',?'),',');value=value.replace(/^,|,$/,'');node.style[TRANSITION_CAMEL]=value;}},_onNativeEnd:function(e){var node=this,uid=Y.stamp(node),event=e,name=Transition._toCamel(event.propertyName),elapsed=event.elapsedTime,attrs=Transition._nodeAttrs[uid],attr=attrs[name],anim=(attr)?attr.transition:null,data,config;if(anim){anim.removeProperty(name);anim._endNative(name);config=anim._config[name];data={type:'propertyEnd',propertyName:name,elapsedTime:elapsed,config:config};if(config&&config.on&&config.on.end){config.on.end.call(Y.one(node),data);}
if(anim._count<=0){anim._end(elapsed);}}},destroy:function(){var anim=this;node.removeEventListener(TRANSITION_END,anim._onNativeEnd,false);anim._node=null;}};Y.Transition=Transition;Y.TransitionNative=Transition;Y.Node.prototype.transition=function(name,config,callback){var
transitionAttrs=Transition._nodeAttrs[Y.stamp(this._node)],anim=(transitionAttrs)?transitionAttrs.transition||null:null,fxConfig,prop;if(typeof name==='string'){if(typeof config==='function'){callback=config;config=null;}
fxConfig=Transition.fx[name];if(config&&typeof config!=='boolean'){config=Y.clone(config);for(prop in fxConfig){if(fxConfig.hasOwnProperty(prop)){if(!(prop in config)){config[prop]=fxConfig[prop];}}}}else{config=fxConfig;}}else{callback=config;config=name;}
if(anim&&!anim._running){anim.init(this,config);}else{anim=new Transition(this._node,config);}
anim.run(callback);return this;};Y.Node.prototype.show=function(name,config,callback){this._show();if(name&&Y.Transition){if(typeof name!=='string'&&!name.push){if(typeof config==='function'){callback=config;config=name;}
name=this.SHOW_TRANSITION;}
this.transition(name,config,callback);}
return this;};var _wrapCallBack=function(anim,fn,callback){return function(){if(fn){fn.call(anim);}
if(callback){callback.apply(anim._node,arguments);}};};Y.Node.prototype.hide=function(name,config,callback){if(name&&Y.Transition){if(typeof config==='function'){callback=config;config=null;}
callback=_wrapCallBack(this,this._hide,callback);if(typeof name!=='string'&&!name.push){if(typeof config==='function'){callback=config;config=name;}
name=this.HIDE_TRANSITION;}
this.transition(name,config,callback);}else{this._hide();}
return this;};Y.NodeList.prototype.transition=function(config,callback){var nodes=this._nodes,i=0,node;while((node=nodes[i++])){Y.one(node).transition(config,callback);}
return this;};Y.Node.prototype.toggleView=function(name,on){var callback;this._toggles=this._toggles||[];if(typeof name=='boolean'){on=name;}
if(typeof on==='undefined'&&name in this._toggles){on=!this._toggles[name];}
on=(on)?1:0;if(on){this._show();}else{callback=_wrapCallBack(anim,this._hide);}
this._toggles[name]=on;this.transition(Y.Transition.toggles[name][on],callback);};Y.NodeList.prototype.toggleView=function(config,callback){var nodes=this._nodes,i=0,node;while((node=nodes[i++])){Y.one(node).toggleView(config,callback);}
return this;};Y.mix(Transition.fx,{fadeOut:{opacity:0,duration:0.5,easing:'ease-out'},fadeIn:{opacity:1,duration:0.5,easing:'ease-in'},sizeOut:{height:0,width:0,duration:0.75,easing:'ease-out'},sizeIn:{height:function(node){return node.get('scrollHeight')+'px';},width:function(node){return node.get('scrollWidth')+'px';},duration:0.5,easing:'ease-in',on:{start:function(){var overflow=this.getStyle('overflow');if(overflow!=='hidden'){this.setStyle('overflow','hidden');this._transitionOverflow=overflow;}},end:function(){if(this._transitionOverflow){this.setStyle('overflow',this._transitionOverflow);}}}}});Y.mix(Transition.toggles,{size:['sizeIn','sizeOut'],fade:['fadeOut','fadeIn']});},'3.3.0',{requires:['node-base']});YUI.add('transition-timer',function(Y){var Transition=Y.Transition;Y.mix(Transition.prototype,{_start:function(){if(Transition.useNative){this._runNative();}else{this._runTimer();}},_runTimer:function(){var anim=this;anim._initAttrs();Transition._running[Y.stamp(anim)]=anim;anim._startTime=new Date();Transition._startTimer();},_endTimer:function(){var anim=this;delete Transition._running[Y.stamp(anim)];anim._startTime=null;},_runFrame:function(){var t=new Date()-this._startTime;this._runAttrs(t);},_runAttrs:function(time){var anim=this,node=anim._node,config=anim._config,uid=Y.stamp(node),attrs=Transition._nodeAttrs[uid],customAttr=Transition.behaviors,done=false,allDone=false,data,name,attribute,setter,elapsed,delay,d,t,i;for(name in attrs){attribute=attrs[name];if((attribute&&attribute.transition===anim)){d=attribute.duration;delay=attribute.delay;elapsed=(time-delay)/ 1000;t=time;data={type:'propertyEnd',propertyName:name,config:config,elapsedTime:elapsed};setter=(i in customAttr&&'set'in customAttr[i])?customAttr[i].set:Transition.DEFAULT_SETTER;done=(t>=d);if(t>d){t=d;}
if(!delay||time>=delay){setter(anim,name,attribute.from,attribute.to,t-delay,d-delay,attribute.easing,attribute.unit);if(done){delete attrs[name];anim._count--;if(config[name]&&config[name].on&&config[name].on.end){config[name].on.end.call(Y.one(node),data);}
if(!allDone&&anim._count<=0){allDone=true;anim._end(elapsed);anim._endTimer();}}}}}},_initAttrs:function(){var anim=this,customAttr=Transition.behaviors,uid=Y.stamp(anim._node),attrs=Transition._nodeAttrs[uid],attribute,duration,delay,easing,val,name,mTo,mFrom,unit,begin,end;for(name in attrs){attribute=attrs[name];if(attrs.hasOwnProperty(name)&&(attribute&&attribute.transition===anim)){duration=attribute.duration*1000;delay=attribute.delay*1000;easing=attribute.easing;val=attribute.value;if(name in anim._node.style||name in Y.DOM.CUSTOM_STYLES){begin=(name in customAttr&&'get'in customAttr[name])?customAttr[name].get(anim,name):Transition.DEFAULT_GETTER(anim,name);mFrom=Transition.RE_UNITS.exec(begin);mTo=Transition.RE_UNITS.exec(val);begin=mFrom?mFrom[1]:begin;end=mTo?mTo[1]:val;unit=mTo?mTo[2]:mFrom?mFrom[2]:'';if(!unit&&Transition.RE_DEFAULT_UNIT.test(name)){unit=Transition.DEFAULT_UNIT;}
if(typeof easing==='string'){if(easing.indexOf('cubic-bezier')>-1){easing=easing.substring(13,easing.length-1).split(',');}else if(Transition.easings[easing]){easing=Transition.easings[easing];}}
attribute.from=Number(begin);attribute.to=Number(end);attribute.unit=unit;attribute.easing=easing;attribute.duration=duration+delay;attribute.delay=delay;}else{delete attrs[name];anim._count--;}}}},destroy:function(){this.detachAll();this._node=null;}},true);Y.mix(Y.Transition,{_runtimeAttrs:{},RE_DEFAULT_UNIT:/^width|height|top|right|bottom|left|margin.*|padding.*|border.*$/i,DEFAULT_UNIT:'px',intervalTime:20,behaviors:{left:{get:function(anim,attr){return Y.DOM._getAttrOffset(anim._node,attr);}}},DEFAULT_SETTER:function(anim,att,from,to,elapsed,duration,fn,unit){from=Number(from);to=Number(to);var node=anim._node,val=Transition.cubicBezier(fn,elapsed / duration);val=from+val[0]*(to-from);if(node){if(att in node.style||att in Y.DOM.CUSTOM_STYLES){unit=unit||'';Y.DOM.setStyle(node,att,val+unit);}}else{anim._end();}},DEFAULT_GETTER:function(anim,att){var node=anim._node,val='';if(att in node.style||att in Y.DOM.CUSTOM_STYLES){val=Y.DOM.getComputedStyle(node,att);}
return val;},_startTimer:function(){if(!Transition._timer){Transition._timer=setInterval(Transition._runFrame,Transition.intervalTime);}},_stopTimer:function(){clearInterval(Transition._timer);Transition._timer=null;},_runFrame:function(){var done=true,anim;for(anim in Transition._running){if(Transition._running[anim]._runFrame){done=false;Transition._running[anim]._runFrame();}}
if(done){Transition._stopTimer();}},cubicBezier:function(p,t){var x0=0,y0=0,x1=p[0],y1=p[1],x2=p[2],y2=p[3],x3=1,y3=0,A=x3-3*x2+3*x1-x0,B=3*x2-6*x1+3*x0,C=3*x1-3*x0,D=x0,E=y3-3*y2+3*y1-y0,F=3*y2-6*y1+3*y0,G=3*y1-3*y0,H=y0,x=(((A*t)+B)*t+C)*t+D,y=(((E*t)+F)*t+G)*t+H;return[x,y];},easings:{ease:[0.25,0,1,0.25],linear:[0,0,1,1],'ease-in':[0.42,0,1,1],'ease-out':[0,0,0.58,1],'ease-in-out':[0.42,0,0.58,1]},_running:{},_timer:null,RE_UNITS:/^(-?\d*\.?\d*){1}(em|ex|px|in|cm|mm|pt|pc|%)*$/},true);Transition.behaviors.top=Transition.behaviors.bottom=Transition.behaviors.right=Transition.behaviors.left;Y.Transition=Transition;},'3.3.0',{requires:['transition-native','node-style']});YUI.add('transition',function(Y){},'3.3.0',{use:['transition-native','transition-timer']});
