<?php 
 $GLOBALS["dictionary"]["Case"]=array (
  'table' => 'cases',
  'audited' => true,
  'unified_search' => true,
  'full_text_search' => true,
  'unified_search_default_enabled' => true,
  'duplicate_merge' => true,
  'comment' => 'Cases are issues or problems that a customer asks a support representative to resolve',
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_SUBJECT',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'audited' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'The short description of the bug',
      'merge_filter' => 'selected',
      'required' => true,
      'importable' => 'required',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
      'audited' => true,
      'comments' => 'Full text of the note',
      'merge_filter' => 'disabled',
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'cases_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'cases_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'cases_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'case_number' => 
    array (
      'name' => 'case_number',
      'vname' => 'LBL_NUMBER',
      'type' => 'int',
      'readonly' => true,
      'len' => 11,
      'required' => true,
      'auto_increment' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'Visual unique identifier',
      'duplicate_merge' => 'disabled',
      'disable_num_format' => true,
      'studio' => 
      array (
        'quickcreate' => false,
      ),
    ),
    'type' => 
    array (
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'orsok_gaedamala_list',
      'len' => 100,
      'comment' => 'The type of issue (ex: issue, feature)',
      'merge_filter' => 'disabled',
      'required' => true,
      'audited' => true,
      'massupdate' => '1',
      'comments' => 'The type of issue (ex: issue, feature)',
    ),
    'status' => 
    array (
      'name' => 'status',
      'vname' => 'LBL_STATUS',
      'type' => 'enum',
      'options' => 'case_status_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'The status of the case',
    ),
    'priority' => 
    array (
      'name' => 'priority',
      'vname' => 'LBL_PRIORITY',
      'type' => 'enum',
      'options' => 'case_priority_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'The priority of the case',
      'default' => 'P2',
      'comments' => 'The priority of the case',
      'merge_filter' => 'disabled',
    ),
    'resolution' => 
    array (
      'name' => 'resolution',
      'vname' => 'LBL_RESOLUTION',
      'type' => 'text',
      'comment' => 'The resolution of the case',
      'audited' => true,
      'comments' => 'The resolution of the case',
      'merge_filter' => 'disabled',
      'rows' => '4',
      'cols' => '20',
    ),
    'work_log' => 
    array (
      'name' => 'work_log',
      'vname' => 'LBL_WORK_LOG',
      'type' => 'text',
      'comment' => 'Free-form text used to denote activities of interest',
    ),
    'account_name' => 
    array (
      'name' => 'account_name',
      'rname' => 'name',
      'id_name' => 'account_id',
      'vname' => 'LBL_ACCOUNT_NAME',
      'type' => 'relate',
      'link' => 'accounts',
      'table' => 'accounts',
      'join_name' => 'accounts',
      'isnull' => 'true',
      'module' => 'Accounts',
      'dbType' => 'varchar',
      'len' => 100,
      'source' => 'non-db',
      'unified_search' => true,
      'comment' => 'The name of the account represented by the account_id field',
      'required' => true,
      'importable' => 'required',
    ),
    'account_name1' => 
    array (
      'name' => 'account_name1',
      'source' => 'non-db',
      'type' => 'text',
      'len' => 100,
      'importable' => 'false',
      'studio' => 
      array (
        'formula' => false,
      ),
    ),
    'account_id' => 
    array (
      'name' => 'account_id',
      'type' => 'relate',
      'dbType' => 'id',
      'rname' => 'id',
      'module' => 'Accounts',
      'id_name' => 'account_id',
      'reportable' => false,
      'vname' => 'LBL_ACCOUNT_ID',
      'audited' => true,
      'massupdate' => false,
      'comment' => 'The account to which the case is associated',
    ),
    'tasks' => 
    array (
      'name' => 'tasks',
      'type' => 'link',
      'relationship' => 'case_tasks',
      'source' => 'non-db',
      'vname' => 'LBL_TASKS',
    ),
    'notes' => 
    array (
      'name' => 'notes',
      'type' => 'link',
      'relationship' => 'case_notes',
      'source' => 'non-db',
      'vname' => 'LBL_NOTES',
    ),
    'meetings' => 
    array (
      'name' => 'meetings',
      'type' => 'link',
      'relationship' => 'case_meetings',
      'bean_name' => 'Meeting',
      'source' => 'non-db',
      'vname' => 'LBL_MEETINGS',
    ),
    'emails' => 
    array (
      'name' => 'emails',
      'type' => 'link',
      'relationship' => 'emails_cases_rel',
      'source' => 'non-db',
      'vname' => 'LBL_EMAILS',
    ),
    'documents' => 
    array (
      'name' => 'documents',
      'type' => 'link',
      'relationship' => 'documents_cases',
      'source' => 'non-db',
      'vname' => 'LBL_DOCUMENTS_SUBPANEL_TITLE',
    ),
    'kbdocuments' => 
    array (
      'name' => 'kbdocuments',
      'type' => 'link',
      'relationship' => 'case_kbdocuments',
      'source' => 'non-db',
      'vname' => 'LBL_KBDOCUMENTS_SUBPANEL_TITLE',
    ),
    'calls' => 
    array (
      'name' => 'calls',
      'type' => 'link',
      'relationship' => 'case_calls',
      'source' => 'non-db',
      'vname' => 'LBL_CALLS',
    ),
    'bugs' => 
    array (
      'name' => 'bugs',
      'type' => 'link',
      'relationship' => 'cases_bugs',
      'source' => 'non-db',
      'vname' => 'LBL_BUGS',
    ),
    'contacts' => 
    array (
      'name' => 'contacts',
      'type' => 'link',
      'relationship' => 'contacts_cases',
      'source' => 'non-db',
      'vname' => 'LBL_CONTACTS',
    ),
    'accounts' => 
    array (
      'name' => 'accounts',
      'type' => 'link',
      'relationship' => 'account_cases',
      'link_type' => 'one',
      'side' => 'right',
      'source' => 'non-db',
      'vname' => 'LBL_ACCOUNT',
    ),
    'project' => 
    array (
      'name' => 'project',
      'type' => 'link',
      'relationship' => 'projects_cases',
      'source' => 'non-db',
      'vname' => 'LBL_PROJECTS',
    ),
    'uppruni_c' => 
    array (
      'labelValue' => 'Upprunadeild:',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'uppruni_c',
      'vname' => 'LBL_UPPRUNI',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'deildir_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Casesuppruni_c',
      'custom_module' => 'Cases',
    ),
    'typa_c' => 
    array (
      'labelValue' => 'Týpa:',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'typa_c',
      'vname' => 'LBL_TYPA',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'gaedaskyrslur_gerd_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Casestypa_c',
      'custom_module' => 'Cases',
    ),
    'vsoff_offset_cases' => 
    array (
      'name' => 'vsoff_offset_cases',
      'type' => 'link',
      'relationship' => 'vsoff_offset_cases',
      'source' => 'non-db',
      'vname' => 'LBL_VSOFF_OFFSET_CASES_FROM_VSOFF_OFFSET_TITLE',
    ),
    'vsoff_offset_cases_name' => 
    array (
      'name' => 'vsoff_offset_cases_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSOFF_OFFSET_CASES_FROM_VSOFF_OFFSET_TITLE',
      'save' => true,
      'id_name' => 'vsoff_offs4c0a_offset_ida',
      'link' => 'vsoff_offset_cases',
      'table' => 'vsoff_offset',
      'module' => 'vsoff_Offset',
      'rname' => 'name',
    ),
    'vsoff_offs4c0a_offset_ida' => 
    array (
      'name' => 'vsoff_offs4c0a_offset_ida',
      'type' => 'link',
      'relationship' => 'vsoff_offset_cases',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSOFF_OFFSET_CASES_FROM_CASES_TITLE',
    ),
    'vssti_stimplar_cases' => 
    array (
      'name' => 'vssti_stimplar_cases',
      'type' => 'link',
      'relationship' => 'vssti_stimplar_cases',
      'source' => 'non-db',
      'vname' => 'LBL_VSSTI_STIMPLAR_CASES_FROM_VSSTI_STIMPLAR_TITLE',
    ),
    'vssti_stimplar_cases_name' => 
    array (
      'name' => 'vssti_stimplar_cases_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSSTI_STIMPLAR_CASES_FROM_VSSTI_STIMPLAR_TITLE',
      'save' => true,
      'id_name' => 'vssti_stim89b2timplar_ida',
      'link' => 'vssti_stimplar_cases',
      'table' => 'vssti_stimplar',
      'module' => 'vssti_Stimplar',
      'rname' => 'name',
    ),
    'vssti_stim89b2timplar_ida' => 
    array (
      'name' => 'vssti_stim89b2timplar_ida',
      'type' => 'link',
      'relationship' => 'vssti_stimplar_cases',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSSTI_STIMPLAR_CASES_FROM_CASES_TITLE',
    ),
    'vsumb_umbudir_cases' => 
    array (
      'name' => 'vsumb_umbudir_cases',
      'type' => 'link',
      'relationship' => 'vsumb_umbudir_cases',
      'source' => 'non-db',
      'vname' => 'LBL_VSUMB_UMBUDIR_CASES_FROM_VSUMB_UMBUDIR_TITLE',
    ),
    'vsumb_umbudir_cases_name' => 
    array (
      'name' => 'vsumb_umbudir_cases_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSUMB_UMBUDIR_CASES_FROM_VSUMB_UMBUDIR_TITLE',
      'save' => true,
      'id_name' => 'vsumb_umbu3408umbudir_ida',
      'link' => 'vsumb_umbudir_cases',
      'table' => 'vsumb_umbudir',
      'module' => 'vsumb_Umbudir',
      'rname' => 'name',
    ),
    'vsumb_umbu3408umbudir_ida' => 
    array (
      'name' => 'vsumb_umbu3408umbudir_ida',
      'type' => 'link',
      'relationship' => 'vsumb_umbudir_cases',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSUMB_UMBUDIR_CASES_FROM_CASES_TITLE',
    ),
    'vssaf_safnformur_cases' => 
    array (
      'name' => 'vssaf_safnformur_cases',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_cases',
      'source' => 'non-db',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_CASES_FROM_VSSAF_SAFNFORMUR_TITLE',
    ),
    'vssaf_safnformur_cases_name' => 
    array (
      'name' => 'vssaf_safnformur_cases_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_CASES_FROM_VSSAF_SAFNFORMUR_TITLE',
      'save' => true,
      'id_name' => 'vssaf_safn9f38nformur_ida',
      'link' => 'vssaf_safnformur_cases',
      'table' => 'vssaf_safnformur',
      'module' => 'vssaf_Safnformur',
      'rname' => 'name',
    ),
    'vssaf_safn9f38nformur_ida' => 
    array (
      'name' => 'vssaf_safn9f38nformur_ida',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_cases',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_CASES_FROM_CASES_TITLE',
    ),
    'uppgotvast_c' => 
    array (
      'labelValue' => 'Uppgötvast í:',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'uppgotvast_c',
      'vname' => 'LBL_UPPGOTVAST',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'deildir_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'Casesuppgotvast_c',
      'custom_module' => 'Cases',
    ),
    'vsdig_digital_cases' => 
    array (
      'name' => 'vsdig_digital_cases',
      'type' => 'link',
      'relationship' => 'vsdig_digital_cases',
      'source' => 'non-db',
      'vname' => 'LBL_VSDIG_DIGITAL_CASES_FROM_VSDIG_DIGITAL_TITLE',
    ),
    'vsdig_digital_cases_name' => 
    array (
      'name' => 'vsdig_digital_cases_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSDIG_DIGITAL_CASES_FROM_VSDIG_DIGITAL_TITLE',
      'save' => true,
      'id_name' => 'vsdig_digif8a3digital_ida',
      'link' => 'vsdig_digital_cases',
      'table' => 'vsdig_digital',
      'module' => 'vsdig_Digital',
      'rname' => 'name',
    ),
    'vsdig_digif8a3digital_ida' => 
    array (
      'name' => 'vsdig_digif8a3digital_ida',
      'type' => 'link',
      'relationship' => 'vsdig_digital_cases',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSDIG_DIGITAL_CASES_FROM_CASES_TITLE',
    ),
    'cases_svartilvv_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cases_svartilvv_c',
      'vname' => 'LBL_CASES_SVARTILVV',
      'type' => 'text',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '6',
      'cols' => '80',
      'id' => 'Casescases_svartilvv_c',
      'custom_module' => 'Cases',
    ),
    'cases_fyrirbyggjandi_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cases_fyrirbyggjandi_c',
      'vname' => 'LBL_CASES_FYRIRBYGGJANDI',
      'type' => 'text',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '6',
      'cols' => '80',
      'id' => 'Casescases_fyrirbyggjandi_c',
      'custom_module' => 'Cases',
    ),
    'cases_dagssvars_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cases_dagssvars_c',
      'vname' => 'LBL_CASES_DAGSSVARS',
      'type' => 'date',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'Casescases_dagssvars_c',
      'custom_module' => 'Cases',
    ),
    'cases_malilokid_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cases_malilokid_c',
      'vname' => 'LBL_CASES_MALILOKID',
      'type' => 'date',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'Casescases_malilokid_c',
      'custom_module' => 'Cases',
    ),
    'cases_kostnadur_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cases_kostnadur_c',
      'vname' => 'LBL_CASES_KOSTNADUR',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'Casescases_kostnadur_c',
      'custom_module' => 'Cases',
    ),
    'currency_id' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'currency_id',
      'vname' => 'LBL_CURRENCY',
      'type' => 'currency_id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'dbType' => 'id',
      'studio' => 'visible',
      'function' => 
      array (
        'name' => 'getCurrencyDropDown',
        'returns' => 'html',
      ),
      'id' => 'Casescurrency_id',
      'custom_module' => 'Cases',
    ),
    'cases_kostnakstur_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cases_kostnakstur_c',
      'vname' => 'LBL_CASES_KOSTNAKSTUR',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'Casescases_kostnakstur_c',
      'custom_module' => 'Cases',
    ),
    'cases_kostnannad_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cases_kostnannad_c',
      'vname' => 'LBL_CASES_KOSTNANNAD',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'Casescases_kostnannad_c',
      'custom_module' => 'Cases',
    ),
    'cases_kreditafsl_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'cases_kreditafsl_c',
      'vname' => 'LBL_CASES_KREDITAFSL',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'Casescases_kreditafsl_c',
      'custom_module' => 'Cases',
    ),
  ),
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'casespk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    'number' => 
    array (
      'name' => 'casesnumk',
      'type' => 'unique',
      'fields' => 
      array (
        0 => 'case_number',
      ),
    ),
    0 => 
    array (
      'name' => 'case_number',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'case_number',
      ),
    ),
    1 => 
    array (
      'name' => 'idx_case_name',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'name',
      ),
    ),
    2 => 
    array (
      'name' => 'idx_account_id',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'account_id',
      ),
    ),
    3 => 
    array (
      'name' => 'idx_cases_stat_del',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'assigned_user_id',
        1 => 'status',
        2 => 'deleted',
      ),
    ),
  ),
  'relationships' => 
  array (
    'cases_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Cases',
      'rhs_table' => 'cases',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'cases_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Cases',
      'rhs_table' => 'cases',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'cases_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Cases',
      'rhs_table' => 'cases',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'case_calls' => 
    array (
      'lhs_module' => 'Cases',
      'lhs_table' => 'cases',
      'lhs_key' => 'id',
      'rhs_module' => 'Calls',
      'rhs_table' => 'calls',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Cases',
    ),
    'case_tasks' => 
    array (
      'lhs_module' => 'Cases',
      'lhs_table' => 'cases',
      'lhs_key' => 'id',
      'rhs_module' => 'Tasks',
      'rhs_table' => 'tasks',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Cases',
    ),
    'case_notes' => 
    array (
      'lhs_module' => 'Cases',
      'lhs_table' => 'cases',
      'lhs_key' => 'id',
      'rhs_module' => 'Notes',
      'rhs_table' => 'notes',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Cases',
    ),
    'case_meetings' => 
    array (
      'lhs_module' => 'Cases',
      'lhs_table' => 'cases',
      'lhs_key' => 'id',
      'rhs_module' => 'Meetings',
      'rhs_table' => 'meetings',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Cases',
    ),
    'case_emails' => 
    array (
      'lhs_module' => 'Cases',
      'lhs_table' => 'cases',
      'lhs_key' => 'id',
      'rhs_module' => 'Emails',
      'rhs_table' => 'emails',
      'rhs_key' => 'parent_id',
      'relationship_type' => 'one-to-many',
      'relationship_role_column' => 'parent_type',
      'relationship_role_column_value' => 'Cases',
    ),
  ),
  'optimistic_locking' => true,
  'templates' => 
  array (
    'issue' => 'issue',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);