<?php 
 $GLOBALS["dictionary"]["vsoff_Offset"]=array (
  'table' => 'vsoff_offset',
  'audited' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_SUBJECT',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'audited' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'The short description of the bug',
      'merge_filter' => 'selected',
      'required' => true,
      'importable' => 'required',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => '3',
      'cols' => '126',
      'required' => true,
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'vsoff_offset_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'vsoff_offset_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'vsoff_offset_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'vsoff_offset_number' => 
    array (
      'name' => 'vsoff_offset_number',
      'vname' => 'LBL_NUMBER',
      'type' => 'int',
      'readonly' => true,
      'len' => 11,
      'required' => true,
      'auto_increment' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'Visual unique identifier',
      'duplicate_merge' => 'disabled',
      'disable_num_format' => true,
      'studio' => 
      array (
        'quickcreate' => false,
      ),
    ),
    'type' => 
    array (
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'vsoff_offset_type_dom',
      'len' => 255,
      'comment' => 'The type of issue (ex: issue, feature)',
      'merge_filter' => 'enabled',
    ),
    'status' => 
    array (
      'name' => 'status',
      'vname' => 'LBL_STATUS',
      'type' => 'enum',
      'options' => 'vsoff_offset_status_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'The status of the issue',
      'merge_filter' => 'disabled',
      'default' => 'Assigned',
      'required' => true,
      'massupdate' => '1',
      'comments' => 'The status of the issue',
    ),
    'priority' => 
    array (
      'name' => 'priority',
      'vname' => 'LBL_PRIORITY',
      'type' => 'enum',
      'options' => 'vsoff_offset_priority_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'An indication of the priorty of the issue',
      'merge_filter' => 'enabled',
      'required' => false,
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'resolution' => 
    array (
      'name' => 'resolution',
      'vname' => 'LBL_RESOLUTION',
      'type' => 'enum',
      'options' => 'vsoff_offset_resolution_dom',
      'len' => 255,
      'audited' => true,
      'comment' => 'An indication of how the issue was resolved',
      'merge_filter' => 'enabled',
    ),
    'work_log' => 
    array (
      'name' => 'work_log',
      'vname' => 'LBL_WORK_LOG',
      'type' => 'text',
      'comment' => 'Free-form text used to denote activities of interest',
    ),
    'offset_tilbuid' => 
    array (
      'required' => true,
      'name' => 'offset_tilbuid',
      'vname' => 'LBL_OFFSET_TILBUID',
      'type' => 'datetimecombo',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'size' => '20',
      'dbType' => 'datetime',
      'options' => 'date_range_search_dom',
      'merge_filter' => 'disabled',
      'enable_range_search' => '1',
    ),
    'offset_upplag' => 
    array (
      'required' => true,
      'name' => 'offset_upplag',
      'vname' => 'LBL_OFFSET_UPPLAG',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_arkarfjoldi' => 
    array (
      'required' => true,
      'name' => 'offset_arkarfjoldi',
      'vname' => 'LBL_OFFSET_ARKARFJOLDI',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_fjoldia' => 
    array (
      'required' => true,
      'name' => 'offset_fjoldia',
      'vname' => 'LBL_OFFSET_FJOLDIA',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_prentun' => 
    array (
      'required' => false,
      'name' => 'offset_prentun',
      'vname' => 'LBL_OFFSET_PRENTUN',
      'type' => 'multienum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'offset_prentun_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'offset_uttekt' => 
    array (
      'required' => false,
      'name' => 'offset_uttekt',
      'vname' => 'LBL_OFFSET_UTTEKT',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_formfj4lit' => 
    array (
      'required' => true,
      'name' => 'offset_formfj4lit',
      'vname' => 'LBL_OFFSET_FORMFJ4LIT',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '7',
      'size' => '20',
    ),
    'offset_formfjsvart' => 
    array (
      'required' => true,
      'name' => 'offset_formfjsvart',
      'vname' => 'LBL_OFFSET_FORMFJSVART',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '7',
      'size' => '20',
    ),
    'offset_formfjpantone' => 
    array (
      'required' => true,
      'name' => 'offset_formfjpantone',
      'vname' => 'LBL_OFFSET_FORMFJPANTONE',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '27',
      'size' => '20',
    ),
    'offset_rasti' => 
    array (
      'required' => true,
      'name' => 'offset_rasti',
      'vname' => 'LBL_OFFSET_RASTI',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_rasti_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_ekkimerkja' => 
    array (
      'required' => false,
      'name' => 'offset_ekkimerkja',
      'vname' => 'LBL_OFFSET_EKKIMERKJA',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_profarkir' => 
    array (
      'required' => false,
      'name' => 'offset_profarkir',
      'vname' => 'LBL_OFFSET_PROFARKIR',
      'type' => 'multienum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'offset_profarkir_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'offset_samthykki' => 
    array (
      'required' => false,
      'name' => 'offset_samthykki',
      'vname' => 'LBL_OFFSET_SAMTHYKKI',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '29',
      'size' => '20',
    ),
    'offset_pappir01' => 
    array (
      'required' => true,
      'name' => 'offset_pappir01',
      'vname' => 'LBL_OFFSET_PAPPIR01',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '36',
      'size' => '20',
    ),
    'offset_pappirthyngd01' => 
    array (
      'required' => true,
      'name' => 'offset_pappirthyngd01',
      'vname' => 'LBL_OFFSET_PAPPIRTHYNGD01',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '7',
      'size' => '20',
    ),
    'offset_pappir02' => 
    array (
      'required' => false,
      'name' => 'offset_pappir02',
      'vname' => 'LBL_OFFSET_PAPPIR02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '36',
      'size' => '20',
    ),
    'offset_pappirthyngd02' => 
    array (
      'required' => false,
      'name' => 'offset_pappirthyngd02',
      'vname' => 'LBL_OFFSET_PAPPIRTHYNGD02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '7',
      'size' => '20',
    ),
    'offset_pappir03' => 
    array (
      'required' => false,
      'name' => 'offset_pappir03',
      'vname' => 'LBL_OFFSET_PAPPIR03',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '36',
      'size' => '20',
    ),
    'offset_pappirthyngd03' => 
    array (
      'required' => false,
      'name' => 'offset_pappirthyngd03',
      'vname' => 'LBL_OFFSET_PAPPIRTHYNGD03',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '7',
      'size' => '20',
    ),
    'offset_pappir04' => 
    array (
      'required' => false,
      'name' => 'offset_pappir04',
      'vname' => 'LBL_OFFSET_PAPPIR04',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '36',
      'size' => '20',
    ),
    'offset_pappirthyngd04' => 
    array (
      'required' => false,
      'name' => 'offset_pappirthyngd04',
      'vname' => 'LBL_OFFSET_PAPPIRTHYNGD04',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '7',
      'size' => '20',
    ),
    'offset_pappirstaerd' => 
    array (
      'required' => false,
      'name' => 'offset_pappirstaerd',
      'vname' => 'LBL_OFFSET_PAPPIRSTAERD',
      'type' => 'multienum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'offset_pappirstaerd_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'offset_alager' => 
    array (
      'required' => false,
      'name' => 'offset_alager',
      'vname' => 'LBL_OFFSET_ALAGER',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_kemurfra' => 
    array (
      'required' => false,
      'name' => 'offset_kemurfra',
      'vname' => 'LBL_OFFSET_KEMURFRA',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '22',
      'size' => '20',
    ),
    'offset_lega' => 
    array (
      'required' => false,
      'name' => 'offset_lega',
      'vname' => 'LBL_OFFSET_LEGA',
      'type' => 'multienum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'offset_lega_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
      'default' => '^^',
    ),
    'offset_afskurdur' => 
    array (
      'required' => false,
      'name' => 'offset_afskurdur',
      'vname' => 'LBL_OFFSET_AFSKURDUR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '32',
      'size' => '20',
    ),
    'offset_skoridur' => 
    array (
      'required' => false,
      'name' => 'offset_skoridur',
      'vname' => 'LBL_OFFSET_SKORIDUR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '24',
      'size' => '20',
    ),
    'offset_endari' => 
    array (
      'required' => false,
      'name' => 'offset_endari',
      'vname' => 'LBL_OFFSET_ENDARI',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '25',
      'size' => '20',
    ),
    'offset_annad' => 
    array (
      'required' => false,
      'name' => 'offset_annad',
      'vname' => 'LBL_OFFSET_ANNAD',
      'type' => 'text',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
      'rows' => '8',
      'cols' => '120',
    ),
    'offset_umslog' => 
    array (
      'required' => false,
      'name' => 'offset_umslog',
      'vname' => 'LBL_OFFSET_UMSLOG',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '77',
      'size' => '20',
    ),
    'offset_fragangurath' => 
    array (
      'required' => false,
      'name' => 'offset_fragangurath',
      'vname' => 'LBL_OFFSET_FRAGANGURATH',
      'type' => 'text',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
      'rows' => '1',
      'cols' => '20',
    ),
    'offset_pokkun' => 
    array (
      'required' => false,
      'name' => 'offset_pokkun',
      'vname' => 'LBL_OFFSET_POKKUN',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '79',
      'size' => '20',
    ),
    'offset_stanz' => 
    array (
      'required' => false,
      'name' => 'offset_stanz',
      'vname' => 'LBL_OFFSET_STANZ',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '33',
      'size' => '20',
    ),
    'offset_umframuppl' => 
    array (
      'required' => false,
      'name' => 'offset_umframuppl',
      'vname' => 'LBL_OFFSET_UMFRAMUPPL',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_athugasemd' => 
    array (
      'required' => false,
      'name' => 'offset_athugasemd',
      'vname' => 'LBL_OFFSET_ATHUGASEMD',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '85',
      'size' => '20',
    ),
    'offset_synishorn' => 
    array (
      'required' => false,
      'name' => 'offset_synishorn',
      'vname' => 'LBL_OFFSET_SYNISHORN',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_stadgreitt' => 
    array (
      'required' => false,
      'name' => 'offset_stadgreitt',
      'vname' => 'LBL_OFFSET_STADGREITT',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_sott' => 
    array (
      'required' => false,
      'name' => 'offset_sott',
      'vname' => 'LBL_OFFSET_SOTT',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_senda' => 
    array (
      'required' => false,
      'name' => 'offset_senda',
      'vname' => 'LBL_OFFSET_SENDA',
      'type' => 'text',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '2',
      'cols' => '40',
    ),
    'offset_hringja' => 
    array (
      'required' => false,
      'name' => 'offset_hringja',
      'vname' => 'LBL_OFFSET_HRINGJA',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '20',
      'size' => '20',
    ),
    'offset_prentplotur' => 
    array (
      'required' => true,
      'name' => 'offset_prentplotur',
      'vname' => 'LBL_OFFSET_PRENTPLOTUR',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_prentplotur_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_hendaprentpl' => 
    array (
      'required' => false,
      'name' => 'offset_hendaprentpl',
      'vname' => 'LBL_OFFSET_HENDAPRENTPL',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_geymaafskurd' => 
    array (
      'required' => false,
      'name' => 'offset_geymaafskurd',
      'vname' => 'LBL_OFFSET_GEYMAAFSKURD',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '73',
      'size' => '20',
    ),
    'vsoff_offset_id_c' => 
    array (
      'required' => false,
      'name' => 'vsoff_offset_id_c',
      'vname' => '',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => 36,
      'size' => '20',
    ),
    'offset_endurprentun' => 
    array (
      'required' => false,
      'name' => 'offset_endurprentun',
      'vname' => 'LBL_OFFSET_ENDURPRENTUN',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'id_name' => 'vsoff_offset_id_c',
      'ext2' => 'vsoff_Offset',
      'module' => 'vsoff_Offset',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'offset_velar_dd' => 
    array (
      'required' => true,
      'name' => 'offset_velar_dd',
      'vname' => 'LBL_OFFSET_VELAR_DD',
      'type' => 'enum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_velar_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_velar1_heiti' => 
    array (
      'required' => true,
      'name' => 'offset_velar1_heiti',
      'vname' => 'LBL_OFFSET_VELAR1_HEITI',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '40',
      'size' => '20',
    ),
    'offset_velar_dd2' => 
    array (
      'required' => false,
      'name' => 'offset_velar_dd2',
      'vname' => 'LBL_OFFSET_VELAR_DD2',
      'type' => 'enum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_velar_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_vel2_heiti' => 
    array (
      'required' => false,
      'name' => 'offset_vel2_heiti',
      'vname' => 'LBL_OFFSET_VEL2_HEITI',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '40',
      'size' => '20',
    ),
    'offset_velar_dd3' => 
    array (
      'required' => false,
      'name' => 'offset_velar_dd3',
      'vname' => 'LBL_OFFSET_VELAR_DD3',
      'type' => 'enum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_velar_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_vel3_heiti' => 
    array (
      'required' => false,
      'name' => 'offset_vel3_heiti',
      'vname' => 'LBL_OFFSET_VEL3_HEITI',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '40',
      'size' => '20',
    ),
    'offs_pdfsugar' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'offs_pdfsugar',
      'vname' => 'LBL_OFFS_PDFSUGAR',
      'type' => 'FRPDFButton',
      'massupdate' => 0,
      'default' => 'Get PDF',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'ext2' => '0d96341a-71dd-4628-8b7b-9096aba71ff5',
      'studio' => 'visible',
    ),
    'offset_simi' => 
    array (
      'required' => false,
      'name' => 'offset_simi',
      'vname' => 'LBL_OFFSET_SIMI',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '12',
      'size' => '20',
    ),
    'offset_email' => 
    array (
      'required' => false,
      'name' => 'offset_email',
      'vname' => 'LBL_OFFSET_EMAIL',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '40',
      'size' => '20',
    ),
    'offset_umbedid' => 
    array (
      'required' => true,
      'name' => 'offset_umbedid',
      'vname' => 'LBL_OFFSET_UMBEDID',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '50',
      'size' => '20',
    ),
    'offset_vinnusedill' => 
    array (
      'required' => false,
      'name' => 'offset_vinnusedill',
      'vname' => 'LBL_OFFSET_VINNUSEDILL',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '51',
      'size' => '20',
    ),
    'offset_praktica' => 
    array (
      'required' => false,
      'name' => 'offset_praktica',
      'vname' => 'LBL_OFFSET_PRAKTICA',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_gto' => 
    array (
      'required' => false,
      'name' => 'offset_gto',
      'vname' => 'LBL_OFFSET_GTO',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_sm52' => 
    array (
      'required' => false,
      'name' => 'offset_sm52',
      'vname' => 'LBL_OFFSET_SM52',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_r305' => 
    array (
      'required' => false,
      'name' => 'offset_r305',
      'vname' => 'LBL_OFFSET_R305',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_r704' => 
    array (
      'required' => false,
      'name' => 'offset_r704',
      'vname' => 'LBL_OFFSET_R704',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_r706' => 
    array (
      'required' => false,
      'name' => 'offset_r706',
      'vname' => 'LBL_OFFSET_R706',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_trukk' => 
    array (
      'required' => false,
      'name' => 'offset_trukk',
      'vname' => 'LBL_OFFSET_TRUKK',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_digital' => 
    array (
      'required' => false,
      'name' => 'offset_digital',
      'vname' => 'LBL_OFFSET_DIGITAL',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_4litur' => 
    array (
      'required' => false,
      'name' => 'offset_4litur',
      'vname' => 'LBL_OFFSET_4LITUR',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_svartur' => 
    array (
      'required' => false,
      'name' => 'offset_svartur',
      'vname' => 'LBL_OFFSET_SVARTUR',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_spottlitur' => 
    array (
      'required' => false,
      'name' => 'offset_spottlitur',
      'vname' => 'LBL_OFFSET_SPOTTLITUR',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_spottlitur_nanar' => 
    array (
      'required' => false,
      'name' => 'offset_spottlitur_nanar',
      'vname' => 'LBL_OFFSET_SPOTTLITUR_NANAR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '31',
      'size' => '20',
    ),
    'offset_lakk' => 
    array (
      'required' => false,
      'name' => 'offset_lakk',
      'vname' => 'LBL_OFFSET_LAKK',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_lakk_nanar' => 
    array (
      'required' => false,
      'name' => 'offset_lakk_nanar',
      'vname' => 'LBL_OFFSET_LAKK_NANAR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '39',
      'size' => '20',
    ),
    'offset_odrumegin' => 
    array (
      'required' => false,
      'name' => 'offset_odrumegin',
      'vname' => 'LBL_OFFSET_ODRUMEGIN',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_beggjavegna' => 
    array (
      'required' => false,
      'name' => 'offset_beggjavegna',
      'vname' => 'LBL_OFFSET_BEGGJAVEGNA',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_vidsnuningur' => 
    array (
      'required' => false,
      'name' => 'offset_vidsnuningur',
      'vname' => 'LBL_OFFSET_VIDSNUNINGUR',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_usavidsnuningur' => 
    array (
      'required' => false,
      'name' => 'offset_usavidsnuningur',
      'vname' => 'LBL_OFFSET_USAVIDSNUNINGUR',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_endurpr_dags01' => 
    array (
      'required' => false,
      'name' => 'offset_endurpr_dags01',
      'vname' => 'LBL_OFFSET_ENDURPR_DAGS01',
      'type' => 'date',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'size' => '20',
    ),
    'offset_endurpr_vnr01' => 
    array (
      'required' => false,
      'name' => 'offset_endurpr_vnr01',
      'vname' => 'LBL_OFFSET_ENDURPR_VNR01',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_endurpr_dags02' => 
    array (
      'required' => false,
      'name' => 'offset_endurpr_dags02',
      'vname' => 'LBL_OFFSET_ENDURPR_DAGS02',
      'type' => 'date',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'size' => '20',
    ),
    'offset_endurpr_vnr02' => 
    array (
      'required' => false,
      'name' => 'offset_endurpr_vnr02',
      'vname' => 'LBL_OFFSET_ENDURPR_VNR02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_endurpr_upphafl' => 
    array (
      'required' => false,
      'name' => 'offset_endurpr_upphafl',
      'vname' => 'LBL_OFFSET_ENDURPR_UPPHAFL',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_rasti175' => 
    array (
      'required' => false,
      'name' => 'offset_rasti175',
      'vname' => 'LBL_OFFSET_RASTI175',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_rasti150' => 
    array (
      'required' => false,
      'name' => 'offset_rasti150',
      'vname' => 'LBL_OFFSET_RASTI150',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_rasti133' => 
    array (
      'required' => false,
      'name' => 'offset_rasti133',
      'vname' => 'LBL_OFFSET_RASTI133',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_slembirasti' => 
    array (
      'required' => false,
      'name' => 'offset_slembirasti',
      'vname' => 'LBL_OFFSET_SLEMBIRASTI',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_geymaprentpl' => 
    array (
      'required' => false,
      'name' => 'offset_geymaprentpl',
      'vname' => 'LBL_OFFSET_GEYMAPRENTPL',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_profork_verkkaupi' => 
    array (
      'required' => false,
      'name' => 'offset_profork_verkkaupi',
      'vname' => 'LBL_OFFSET_PROFORK_VERKKAUPI',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_profork_litalaser' => 
    array (
      'required' => false,
      'name' => 'offset_profork_litalaser',
      'vname' => 'LBL_OFFSET_PROFORK_LITALASER',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_pappirstaerd01' => 
    array (
      'required' => true,
      'name' => 'offset_pappirstaerd01',
      'vname' => 'LBL_OFFSET_PAPPIRSTAERD01',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '15',
      'size' => '20',
    ),
    'offset_pappirstaerd02' => 
    array (
      'required' => false,
      'name' => 'offset_pappirstaerd02',
      'vname' => 'LBL_OFFSET_PAPPIRSTAERD02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '15',
      'size' => '20',
    ),
    'offset_pappirstaerd03' => 
    array (
      'required' => false,
      'name' => 'offset_pappirstaerd03',
      'vname' => 'LBL_OFFSET_PAPPIRSTAERD03',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '15',
      'size' => '20',
    ),
    'offset_pappirstaerd04' => 
    array (
      'required' => false,
      'name' => 'offset_pappirstaerd04',
      'vname' => 'LBL_OFFSET_PAPPIRSTAERD04',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '15',
      'size' => '20',
    ),
    'offset_pappirlega01' => 
    array (
      'required' => true,
      'name' => 'offset_pappirlega01',
      'vname' => 'LBL_OFFSET_PAPPIRLEGA01',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_lega_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_pappirlega02' => 
    array (
      'required' => false,
      'name' => 'offset_pappirlega02',
      'vname' => 'LBL_OFFSET_PAPPIRLEGA02',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_lega_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_pappirlega03' => 
    array (
      'required' => false,
      'name' => 'offset_pappirlega03',
      'vname' => 'LBL_OFFSET_PAPPIRLEGA03',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_lega_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_pappirlega04' => 
    array (
      'required' => false,
      'name' => 'offset_pappirlega04',
      'vname' => 'LBL_OFFSET_PAPPIRLEGA04',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_lega_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_skoridur2' => 
    array (
      'required' => false,
      'name' => 'offset_skoridur2',
      'vname' => 'LBL_OFFSET_SKORIDUR2',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '24',
      'size' => '20',
    ),
    'offset_endari2' => 
    array (
      'required' => false,
      'name' => 'offset_endari2',
      'vname' => 'LBL_OFFSET_ENDARI2',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '25',
      'size' => '20',
    ),
    'offset_fellt' => 
    array (
      'required' => false,
      'name' => 'offset_fellt',
      'vname' => 'LBL_OFFSET_FELLT',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_rifgotun' => 
    array (
      'required' => false,
      'name' => 'offset_rifgotun',
      'vname' => 'LBL_OFFSET_RIFGOTUN',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_gotun' => 
    array (
      'required' => false,
      'name' => 'offset_gotun',
      'vname' => 'LBL_OFFSET_GOTUN',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_glosslaminering' => 
    array (
      'required' => false,
      'name' => 'offset_glosslaminering',
      'vname' => 'LBL_OFFSET_GLOSSLAMINERING',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_mattlaminering' => 
    array (
      'required' => false,
      'name' => 'offset_mattlaminering',
      'vname' => 'LBL_OFFSET_MATTLAMINERING',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_gormun' => 
    array (
      'required' => false,
      'name' => 'offset_gormun',
      'vname' => 'LBL_OFFSET_GORMUN',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_gormun_nr' => 
    array (
      'required' => false,
      'name' => 'offset_gormun_nr',
      'vname' => 'LBL_OFFSET_GORMUN_NR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_gormur_litur' => 
    array (
      'required' => false,
      'name' => 'offset_gormur_litur',
      'vname' => 'LBL_OFFSET_GORMUR_LITUR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_saumad' => 
    array (
      'required' => false,
      'name' => 'offset_saumad',
      'vname' => 'LBL_OFFSET_SAUMAD',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_heft' => 
    array (
      'required' => false,
      'name' => 'offset_heft',
      'vname' => 'LBL_OFFSET_HEFT',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_fraest' => 
    array (
      'required' => false,
      'name' => 'offset_fraest',
      'vname' => 'LBL_OFFSET_FRAEST',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_brot' => 
    array (
      'required' => false,
      'name' => 'offset_brot',
      'vname' => 'LBL_OFFSET_BROT',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_brot_nanar' => 
    array (
      'required' => false,
      'name' => 'offset_brot_nanar',
      'vname' => 'LBL_OFFSET_BROT_NANAR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '27',
      'size' => '20',
    ),
    'offset_tolusetning' => 
    array (
      'required' => false,
      'name' => 'offset_tolusetning',
      'vname' => 'LBL_OFFSET_TOLUSETNING',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_tolusetning_fra' => 
    array (
      'required' => false,
      'name' => 'offset_tolusetning_fra',
      'vname' => 'LBL_OFFSET_TOLUSETNING_FRA',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '14',
      'size' => '20',
    ),
    'offset_tolusetning_til' => 
    array (
      'required' => false,
      'name' => 'offset_tolusetning_til',
      'vname' => 'LBL_OFFSET_TOLUSETNING_TIL',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '14',
      'size' => '20',
    ),
    'offset_tolusetning_rit' => 
    array (
      'required' => false,
      'name' => 'offset_tolusetning_rit',
      'vname' => 'LBL_OFFSET_TOLUSETNING_RIT',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '2',
      'size' => '20',
    ),
    'offset_sottmottaka' => 
    array (
      'required' => false,
      'name' => 'offset_sottmottaka',
      'vname' => 'LBL_OFFSET_SOTTMOTTAKA',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_senda_tengilidur' => 
    array (
      'required' => false,
      'name' => 'offset_senda_tengilidur',
      'vname' => 'LBL_OFFSET_SENDA_TENGILIDUR',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_senda_verkkaupa' => 
    array (
      'required' => false,
      'name' => 'offset_senda_verkkaupa',
      'vname' => 'LBL_OFFSET_SENDA_VERKKAUPA',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_senda_hringja' => 
    array (
      'required' => false,
      'name' => 'offset_senda_hringja',
      'vname' => 'LBL_OFFSET_SENDA_HRINGJA',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_senda_ath' => 
    array (
      'required' => false,
      'name' => 'offset_senda_ath',
      'vname' => 'LBL_OFFSET_SENDA_ATH',
      'type' => 'text',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '2',
      'cols' => '20',
      'merge_filter' => 'disabled',
    ),
    'offset_solumenn' => 
    array (
      'required' => true,
      'name' => 'offset_solumenn',
      'vname' => 'LBL_OFFSET_SOLUMENN',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_solumenn_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_upplag02' => 
    array (
      'required' => false,
      'name' => 'offset_upplag02',
      'vname' => 'LBL_OFFSET_UPPLAG02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_upplag03' => 
    array (
      'required' => false,
      'name' => 'offset_upplag03',
      'vname' => 'LBL_OFFSET_UPPLAG03',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_arkarfjoldi02' => 
    array (
      'required' => false,
      'name' => 'offset_arkarfjoldi02',
      'vname' => 'LBL_OFFSET_ARKARFJOLDI02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_arkarfjoldi03' => 
    array (
      'required' => false,
      'name' => 'offset_arkarfjoldi03',
      'vname' => 'LBL_OFFSET_ARKARFJOLDI03',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_fjoldia02' => 
    array (
      'required' => false,
      'name' => 'offset_fjoldia02',
      'vname' => 'LBL_OFFSET_FJOLDIA02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_fjoldia03' => 
    array (
      'required' => false,
      'name' => 'offset_fjoldia03',
      'vname' => 'LBL_OFFSET_FJOLDIA03',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_serstakt' => 
    array (
      'required' => false,
      'name' => 'offset_serstakt',
      'vname' => 'LBL_OFFSET_SERSTAKT',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_serstakt_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_litur_p1' => 
    array (
      'required' => true,
      'name' => 'offset_litur_p1',
      'vname' => 'LBL_OFFSET_LITUR_P1',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '30',
      'size' => '20',
    ),
    'offset_litur_p2' => 
    array (
      'required' => false,
      'name' => 'offset_litur_p2',
      'vname' => 'LBL_OFFSET_LITUR_P2',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '30',
      'size' => '20',
    ),
    'offset_litur_p3' => 
    array (
      'required' => false,
      'name' => 'offset_litur_p3',
      'vname' => 'LBL_OFFSET_LITUR_P3',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '30',
      'size' => '20',
    ),
    'offset_upplag_p1' => 
    array (
      'required' => true,
      'name' => 'offset_upplag_p1',
      'vname' => 'LBL_OFFSET_UPPLAG_P1',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '30',
      'size' => '20',
    ),
    'offset_upplag_p2' => 
    array (
      'required' => false,
      'name' => 'offset_upplag_p2',
      'vname' => 'LBL_OFFSET_UPPLAG_P2',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '30',
      'size' => '20',
    ),
    'offset_upplag_p3' => 
    array (
      'required' => false,
      'name' => 'offset_upplag_p3',
      'vname' => 'LBL_OFFSET_UPPLAG_P3',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '30',
      'size' => '20',
    ),
    'offset_arkarfj_p1' => 
    array (
      'required' => true,
      'name' => 'offset_arkarfj_p1',
      'vname' => 'LBL_OFFSET_ARKARFJ_P1',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '30',
      'size' => '20',
    ),
    'offset_arkarfj_p2' => 
    array (
      'required' => false,
      'name' => 'offset_arkarfj_p2',
      'vname' => 'LBL_OFFSET_ARKARFJ_P2',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '30',
      'size' => '20',
    ),
    'offset_arkarfj_p3' => 
    array (
      'required' => false,
      'name' => 'offset_arkarfj_p3',
      'vname' => 'LBL_OFFSET_ARKARFJ_P3',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '30',
      'size' => '20',
    ),
    'offset_fjoldia_p1' => 
    array (
      'required' => true,
      'name' => 'offset_fjoldia_p1',
      'vname' => 'LBL_OFFSET_FJOLDIA_P1',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '4',
      'size' => '20',
      'disable_num_format' => '',
    ),
    'offset_fjoldia_p2' => 
    array (
      'required' => false,
      'name' => 'offset_fjoldia_p2',
      'vname' => 'LBL_OFFSET_FJOLDIA_P2',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '4',
      'size' => '20',
      'disable_num_format' => '',
    ),
    'offset_fjoldia_p3' => 
    array (
      'required' => false,
      'name' => 'offset_fjoldia_p3',
      'vname' => 'LBL_OFFSET_FJOLDIA_P3',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '4',
      'size' => '20',
      'disable_num_format' => '',
    ),
    'offset_rasti_p2' => 
    array (
      'required' => false,
      'name' => 'offset_rasti_p2',
      'vname' => 'LBL_OFFSET_RASTI_P2',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_rasti_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_rasti_p3' => 
    array (
      'required' => false,
      'name' => 'offset_rasti_p3',
      'vname' => 'LBL_OFFSET_RASTI_P3',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_rasti_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_prentun_p1' => 
    array (
      'required' => true,
      'name' => 'offset_prentun_p1',
      'vname' => 'LBL_OFFSET_PRENTUN_P1',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_prentun_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_prentun_p2' => 
    array (
      'required' => false,
      'name' => 'offset_prentun_p2',
      'vname' => 'LBL_OFFSET_PRENTUN_P2',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_prentun_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_prentun_p3' => 
    array (
      'required' => false,
      'name' => 'offset_prentun_p3',
      'vname' => 'LBL_OFFSET_PRENTUN_P3',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_prentun_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_endurprentun_vnr01' => 
    array (
      'required' => false,
      'name' => 'offset_endurprentun_vnr01',
      'vname' => 'LBL_OFFSET_ENDURPRENTUN_VNR01',
      'type' => 'int',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '9',
      'size' => '20',
      'disable_num_format' => '',
    ),
    'offset_endurprentun_vnr02' => 
    array (
      'required' => false,
      'name' => 'offset_endurprentun_vnr02',
      'vname' => 'LBL_OFFSET_ENDURPRENTUN_VNR02',
      'type' => 'int',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '9',
      'size' => '20',
      'disable_num_format' => '',
    ),
    'offset_endurprentun_upphafl' => 
    array (
      'required' => false,
      'name' => 'offset_endurprentun_upphafl',
      'vname' => 'LBL_OFFSET_ENDURPRENTUN_UPPHAFL',
      'type' => 'int',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '9',
      'size' => '20',
      'disable_num_format' => '',
    ),
    'offset_profarkir_lysing' => 
    array (
      'required' => false,
      'name' => 'offset_profarkir_lysing',
      'vname' => 'LBL_OFFSET_PROFARKIR_LYSING',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '32',
      'size' => '20',
    ),
    'offset_profork_litaproof' => 
    array (
      'required' => false,
      'name' => 'offset_profork_litaproof',
      'vname' => 'LBL_OFFSET_PROFORK_LITAPROOF',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_skoridur_dd' => 
    array (
      'required' => false,
      'name' => 'offset_skoridur_dd',
      'vname' => 'LBL_OFFSET_SKORIDUR_DD',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_skoridur_dd_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_skoridur_dd2' => 
    array (
      'required' => false,
      'name' => 'offset_skoridur_dd2',
      'vname' => 'LBL_OFFSET_SKORIDUR_DD2',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_skoridur_dd_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_umframuppl_ath' => 
    array (
      'required' => false,
      'name' => 'offset_umframuppl_ath',
      'vname' => 'LBL_OFFSET_UMFRAMUPPL_ATH',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '15',
      'size' => '20',
    ),
    'offset_afhending' => 
    array (
      'required' => true,
      'name' => 'offset_afhending',
      'vname' => 'LBL_OFFSET_AFHENDING',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_afhending_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'offset_pdfvinnusedill' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'offset_pdfvinnusedill',
      'vname' => 'LBL_OFFSET_PDFVINNUSEDILL',
      'type' => 'FRPDFButton',
      'massupdate' => 0,
      'default' => 'Gera PDF',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'ext2' => 'deed3343-3947-4865-88fb-343fdc299d00',
      'studio' => 'visible',
    ),
    'offset_afgreidslusedill' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'offset_afgreidslusedill',
      'vname' => 'LBL_OFFSET_AFGREIDSLUSEDILL',
      'type' => 'FRPDFButton',
      'massupdate' => 0,
      'default' => 'Get PDF',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'ext2' => '887e8541-a561-42b3-b713-84c7cd11499b',
      'studio' => 'visible',
    ),
    'currency_id' => 
    array (
      'required' => false,
      'name' => 'currency_id',
      'vname' => 'LBL_CURRENCY',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => 36,
      'size' => '20',
      'studio' => 'visible',
      'function' => 
      array (
        'name' => 'getCurrencyDropDown',
        'returns' => 'html',
      ),
    ),
    'verd_lysing01' => 
    array (
      'required' => true,
      'name' => 'verd_lysing01',
      'vname' => 'LBL_VERD_LYSING01',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'verd_pm01' => 
    array (
      'required' => true,
      'name' => 'verd_pm01',
      'vname' => 'LBL_VERD_PM01',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd01' => 
    array (
      'required' => true,
      'name' => 'verd01',
      'vname' => 'LBL_VERD01',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_lysing02' => 
    array (
      'required' => false,
      'name' => 'verd_lysing02',
      'vname' => 'LBL_VERD_LYSING02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'verd_pm02' => 
    array (
      'required' => false,
      'name' => 'verd_pm02',
      'vname' => 'LBL_VERD_PM02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd02' => 
    array (
      'required' => false,
      'name' => 'verd02',
      'vname' => 'LBL_VERD02',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_lysing03' => 
    array (
      'required' => false,
      'name' => 'verd_lysing03',
      'vname' => 'LBL_VERD_LYSING03',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'verd_pm03' => 
    array (
      'required' => false,
      'name' => 'verd_pm03',
      'vname' => 'LBL_VERD_PM03',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd03' => 
    array (
      'required' => false,
      'name' => 'verd03',
      'vname' => 'LBL_VERD03',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_lysing04' => 
    array (
      'required' => false,
      'name' => 'verd_lysing04',
      'vname' => 'LBL_VERD_LYSING04',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'verd_pm04' => 
    array (
      'required' => false,
      'name' => 'verd_pm04',
      'vname' => 'LBL_VERD_PM04',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd04' => 
    array (
      'required' => false,
      'name' => 'verd04',
      'vname' => 'LBL_VERD04',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_lysing05' => 
    array (
      'required' => false,
      'name' => 'verd_lysing05',
      'vname' => 'LBL_VERD_LYSING05',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'verd_pm05' => 
    array (
      'required' => false,
      'name' => 'verd_pm05',
      'vname' => 'LBL_VERD_PM05',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd05' => 
    array (
      'required' => false,
      'name' => 'verd05',
      'vname' => 'LBL_VERD05',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_lysing06' => 
    array (
      'required' => false,
      'name' => 'verd_lysing06',
      'vname' => 'LBL_VERD_LYSING06',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'verd_pm06' => 
    array (
      'required' => false,
      'name' => 'verd_pm06',
      'vname' => 'LBL_VERD_PM06',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd06' => 
    array (
      'required' => false,
      'name' => 'verd06',
      'vname' => 'LBL_VERD06',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm10' => 
    array (
      'required' => false,
      'name' => 'verd_pm10',
      'vname' => 'LBL_VERD_PM10',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
      'options' => 'Verd_akstur_list',
      'studio' => 'visible',
      'dependency' => false,
      'default' => 'PM901',
    ),
    'verd10' => 
    array (
      'required' => false,
      'name' => 'verd10',
      'vname' => 'LBL_VERD10',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'default' => '5490',
      'options' => 'Verd_akstur_list',
      'studio' => 'visible',
      'dependency' => false,
      'merge_filter' => 'disabled',
    ),
    'verd_pm11' => 
    array (
      'required' => false,
      'name' => 'verd_pm11',
      'vname' => 'LBL_VERD_PM11',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd11' => 
    array (
      'required' => false,
      'name' => 'verd11',
      'vname' => 'LBL_VERD11',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm12' => 
    array (
      'required' => false,
      'name' => 'verd_pm12',
      'vname' => 'LBL_VERD_PM12',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd12' => 
    array (
      'required' => false,
      'name' => 'verd12',
      'vname' => 'LBL_VERD12',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm13' => 
    array (
      'required' => false,
      'name' => 'verd_pm13',
      'vname' => 'LBL_VERD_PM13',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd13' => 
    array (
      'required' => false,
      'name' => 'verd13',
      'vname' => 'LBL_VERD13',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm07' => 
    array (
      'required' => false,
      'name' => 'verd_pm07',
      'vname' => 'LBL_VERD_PM07',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd07' => 
    array (
      'required' => false,
      'name' => 'verd07',
      'vname' => 'LBL_VERD07',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_lysing08' => 
    array (
      'required' => false,
      'name' => 'verd_lysing08',
      'vname' => 'LBL_VERD_LYSING08',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'verd_pm08' => 
    array (
      'required' => false,
      'name' => 'verd_pm08',
      'vname' => 'LBL_VERD_PM08',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd08' => 
    array (
      'required' => false,
      'name' => 'verd08',
      'vname' => 'LBL_VERD08',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_lysing_07' => 
    array (
      'required' => false,
      'name' => 'verd_lysing_07',
      'vname' => 'LBL_VERD_LYSING_07',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'vsoff_offset_contacts' => 
    array (
      'name' => 'vsoff_offset_contacts',
      'type' => 'link',
      'relationship' => 'vsoff_offset_contacts',
      'source' => 'non-db',
      'vname' => 'LBL_VSOFF_OFFSET_CONTACTS_FROM_CONTACTS_TITLE',
    ),
    'vsoff_offset_contacts_name' => 
    array (
      'name' => 'vsoff_offset_contacts_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSOFF_OFFSET_CONTACTS_FROM_CONTACTS_TITLE',
      'save' => true,
      'id_name' => 'vsoff_offs9b6eontacts_ida',
      'link' => 'vsoff_offset_contacts',
      'table' => 'contacts',
      'module' => 'Contacts',
      'rname' => 'name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
    ),
    'vsoff_offs9b6eontacts_ida' => 
    array (
      'name' => 'vsoff_offs9b6eontacts_ida',
      'type' => 'link',
      'relationship' => 'vsoff_offset_contacts',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSOFF_OFFSET_CONTACTS_FROM_VSOFF_OFFSET_TITLE',
    ),
    'vsoff_offset_leads' => 
    array (
      'name' => 'vsoff_offset_leads',
      'type' => 'link',
      'relationship' => 'vsoff_offset_leads',
      'source' => 'non-db',
      'vname' => 'LBL_VSOFF_OFFSET_LEADS_FROM_LEADS_TITLE',
    ),
    'vsoff_offset_leads_name' => 
    array (
      'name' => 'vsoff_offset_leads_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSOFF_OFFSET_LEADS_FROM_LEADS_TITLE',
      'save' => true,
      'id_name' => 'vsoff_offs13cddsleads_ida',
      'link' => 'vsoff_offset_leads',
      'table' => 'leads',
      'module' => 'Leads',
      'rname' => 'name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
    ),
    'vsoff_offs13cddsleads_ida' => 
    array (
      'name' => 'vsoff_offs13cddsleads_ida',
      'type' => 'link',
      'relationship' => 'vsoff_offset_leads',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSOFF_OFFSET_LEADS_FROM_VSOFF_OFFSET_TITLE',
    ),
    'vsoff_offset_accounts' => 
    array (
      'name' => 'vsoff_offset_accounts',
      'type' => 'link',
      'relationship' => 'vsoff_offset_accounts',
      'source' => 'non-db',
      'vname' => 'LBL_VSOFF_OFFSET_ACCOUNTS_FROM_ACCOUNTS_TITLE',
    ),
    'vsoff_offset_accounts_name' => 
    array (
      'name' => 'vsoff_offset_accounts_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSOFF_OFFSET_ACCOUNTS_FROM_ACCOUNTS_TITLE',
      'save' => true,
      'id_name' => 'vsoff_offsb843ccounts_ida',
      'link' => 'vsoff_offset_accounts',
      'table' => 'accounts',
      'module' => 'Accounts',
      'rname' => 'name',
    ),
    'vsoff_offsb843ccounts_ida' => 
    array (
      'name' => 'vsoff_offsb843ccounts_ida',
      'type' => 'link',
      'relationship' => 'vsoff_offset_accounts',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSOFF_OFFSET_ACCOUNTS_FROM_VSOFF_OFFSET_TITLE',
    ),
    'vsoff_offset_cases' => 
    array (
      'name' => 'vsoff_offset_cases',
      'type' => 'link',
      'relationship' => 'vsoff_offset_cases',
      'source' => 'non-db',
      'side' => 'right',
      'vname' => 'LBL_VSOFF_OFFSET_CASES_FROM_CASES_TITLE',
    ),
    'offset_upplag_p3_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'offset_upplag_p3_c',
      'vname' => 'LBL_OFFSET_UPPLAG_P3',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'vsoff_Offsetoffset_upplag_p3_c',
      'custom_module' => 'vsoff_Offset',
    ),
  ),
  'relationships' => 
  array (
    'vsoff_offset_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'vsoff_Offset',
      'rhs_table' => 'vsoff_offset',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'vsoff_offset_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'vsoff_Offset',
      'rhs_table' => 'vsoff_offset',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'vsoff_offset_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'vsoff_Offset',
      'rhs_table' => 'vsoff_offset',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_locking' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'vsoff_offsetpk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    'number' => 
    array (
      'name' => 'vsoff_offsetnumk',
      'type' => 'unique',
      'fields' => 
      array (
        0 => 'vsoff_offset_number',
      ),
    ),
  ),
  'templates' => 
  array (
    'issue' => 'issue',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);