<?php 
 $GLOBALS["dictionary"]["vssaf_Safnformur"]=array (
  'table' => 'vssaf_safnformur',
  'audited' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_SUBJECT',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'audited' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'The short description of the bug',
      'merge_filter' => 'selected',
      'required' => true,
      'importable' => 'required',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'vssaf_safnformur_number' => 
    array (
      'name' => 'vssaf_safnformur_number',
      'vname' => 'LBL_NUMBER',
      'type' => 'int',
      'readonly' => true,
      'len' => 11,
      'required' => true,
      'auto_increment' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'Visual unique identifier',
      'duplicate_merge' => 'disabled',
      'disable_num_format' => true,
      'studio' => 
      array (
        'quickcreate' => false,
      ),
    ),
    'type' => 
    array (
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'vssaf_safnformur_type_dom',
      'len' => 255,
      'comment' => 'The type of issue (ex: issue, feature)',
      'merge_filter' => 'enabled',
    ),
    'status' => 
    array (
      'name' => 'status',
      'vname' => 'LBL_STATUS',
      'type' => 'enum',
      'options' => 'vssaf_safnformur_status_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'The status of the issue',
      'merge_filter' => 'disabled',
      'default' => 'Assigned',
      'required' => true,
      'massupdate' => '1',
      'comments' => 'The status of the issue',
    ),
    'priority' => 
    array (
      'name' => 'priority',
      'vname' => 'LBL_PRIORITY',
      'type' => 'enum',
      'options' => 'vssaf_safnformur_priority_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'An indication of the priorty of the issue',
      'merge_filter' => 'enabled',
    ),
    'resolution' => 
    array (
      'name' => 'resolution',
      'vname' => 'LBL_RESOLUTION',
      'type' => 'enum',
      'options' => 'vssaf_safnformur_resolution_dom',
      'len' => 255,
      'audited' => true,
      'comment' => 'An indication of how the issue was resolved',
      'merge_filter' => 'enabled',
    ),
    'work_log' => 
    array (
      'name' => 'work_log',
      'vname' => 'LBL_WORK_LOG',
      'type' => 'text',
      'comment' => 'Free-form text used to denote activities of interest',
    ),
    'safnformur_upplag' => 
    array (
      'required' => true,
      'name' => 'safnformur_upplag',
      'vname' => 'LBL_SAFNFORMUR_UPPLAG',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_fjoldinafna' => 
    array (
      'required' => true,
      'name' => 'safnformur_fjoldinafna',
      'vname' => 'LBL_SAFNFORMUR_FJOLDINAFNA',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_fjoldia' => 
    array (
      'required' => false,
      'name' => 'safnformur_fjoldia',
      'vname' => 'LBL_SAFNFORMUR_FJOLDIA',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_litir' => 
    array (
      'required' => true,
      'name' => 'safnformur_litir',
      'vname' => 'LBL_SAFNFORMUR_LITIR',
      'type' => 'multienum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'safnformur_litir_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'safnformur_liturnanar' => 
    array (
      'required' => false,
      'name' => 'safnformur_liturnanar',
      'vname' => 'LBL_SAFNFORMUR_LITURNANAR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_prentun' => 
    array (
      'required' => true,
      'name' => 'safnformur_prentun',
      'vname' => 'LBL_SAFNFORMUR_PRENTUN',
      'type' => 'multienum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'safnformur_prentun_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'safnformur_fragangur' => 
    array (
      'required' => true,
      'name' => 'safnformur_fragangur',
      'vname' => 'LBL_SAFNFORMUR_FRAGANGUR',
      'type' => 'multienum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'safnformur_fragangur_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'safnformur_fragangurnanar' => 
    array (
      'required' => false,
      'name' => 'safnformur_fragangurnanar',
      'vname' => 'LBL_SAFNFORMUR_FRAGANGURNANAR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_annad' => 
    array (
      'required' => false,
      'name' => 'safnformur_annad',
      'vname' => 'LBL_SAFNFORMUR_ANNAD',
      'type' => 'text',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
      'rows' => '8',
      'cols' => '120',
    ),
    'safnformur_stanz' => 
    array (
      'required' => false,
      'name' => 'safnformur_stanz',
      'vname' => 'LBL_SAFNFORMUR_STANZ',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_ath' => 
    array (
      'required' => false,
      'name' => 'safnformur_ath',
      'vname' => 'LBL_SAFNFORMUR_ATH',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_geymasynishorn' => 
    array (
      'required' => false,
      'name' => 'safnformur_geymasynishorn',
      'vname' => 'LBL_SAFNFORMUR_GEYMASYNISHORN',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_sendasynishorn' => 
    array (
      'required' => false,
      'name' => 'safnformur_sendasynishorn',
      'vname' => 'LBL_SAFNFORMUR_SENDASYNISHORN',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_afhending' => 
    array (
      'required' => false,
      'name' => 'safnformur_afhending',
      'vname' => 'LBL_SAFNFORMUR_AFHENDING',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => 'sott',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'safnformur_afhending_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'safnformur_hringja' => 
    array (
      'required' => false,
      'name' => 'safnformur_hringja',
      'vname' => 'LBL_SAFNFORMUR_HRINGJA',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_oskasttilbuid' => 
    array (
      'required' => true,
      'name' => 'safnformur_oskasttilbuid',
      'vname' => 'LBL_SAFNFORMUR_OSKASTTILBUID',
      'type' => 'datetimecombo',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'size' => '20',
      'dbType' => 'datetime',
      'options' => 'date_range_search_dom',
      'merge_filter' => 'disabled',
      'enable_range_search' => '1',
    ),
    'safnformur_solumadur' => 
    array (
      'required' => true,
      'name' => 'safnformur_solumadur',
      'vname' => 'LBL_SAFNFORMUR_SOLUMADUR',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_solumenn_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'safnformur_pappirsthykkt' => 
    array (
      'required' => false,
      'name' => 'safnformur_pappirsthykkt',
      'vname' => 'LBL_SAFNFORMUR_PAPPIRSTHYKKT',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_simi' => 
    array (
      'required' => false,
      'name' => 'safnformur_simi',
      'vname' => 'LBL_SAFNFORMUR_SIMI',
      'type' => 'int',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '7',
      'size' => '20',
      'disable_num_format' => '',
    ),
    'safnformur_email' => 
    array (
      'required' => false,
      'name' => 'safnformur_email',
      'vname' => 'LBL_SAFNFORMUR_EMAIL',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_umbedid' => 
    array (
      'required' => true,
      'name' => 'safnformur_umbedid',
      'vname' => 'LBL_SAFNFORMUR_UMBEDID',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_vinnusedill' => 
    array (
      'required' => false,
      'name' => 'safnformur_vinnusedill',
      'vname' => 'LBL_SAFNFORMUR_VINNUSEDILL',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'disable_num_format' => '',
      'ext2' => 'TEST',
      'studio' => 'visible',
    ),
    'safnformur_litur' => 
    array (
      'required' => true,
      'name' => 'safnformur_litur',
      'vname' => 'LBL_SAFNFORMUR_LITUR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_prentun_dd' => 
    array (
      'required' => true,
      'name' => 'safnformur_prentun_dd',
      'vname' => 'LBL_SAFNFORMUR_PRENTUN_DD',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_prentun_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'safnformur_felling' => 
    array (
      'required' => false,
      'name' => 'safnformur_felling',
      'vname' => 'LBL_SAFNFORMUR_FELLING',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_felling_lysing' => 
    array (
      'required' => false,
      'name' => 'safnformur_felling_lysing',
      'vname' => 'LBL_SAFNFORMUR_FELLING_LYSING',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_brot' => 
    array (
      'required' => false,
      'name' => 'safnformur_brot',
      'vname' => 'LBL_SAFNFORMUR_BROT',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_brot_lysing' => 
    array (
      'required' => false,
      'name' => 'safnformur_brot_lysing',
      'vname' => 'LBL_SAFNFORMUR_BROT_LYSING',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_gotun' => 
    array (
      'required' => false,
      'name' => 'safnformur_gotun',
      'vname' => 'LBL_SAFNFORMUR_GOTUN',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_gotun_lysing' => 
    array (
      'required' => false,
      'name' => 'safnformur_gotun_lysing',
      'vname' => 'LBL_SAFNFORMUR_GOTUN_LYSING',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_tolusetning' => 
    array (
      'required' => false,
      'name' => 'safnformur_tolusetning',
      'vname' => 'LBL_SAFNFORMUR_TOLUSETNING',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_tolusetning_fra' => 
    array (
      'required' => false,
      'name' => 'safnformur_tolusetning_fra',
      'vname' => 'LBL_SAFNFORMUR_TOLUSETNING_FRA',
      'type' => 'int',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'disable_num_format' => '',
    ),
    'safnformur_tolusetning_til' => 
    array (
      'required' => false,
      'name' => 'safnformur_tolusetning_til',
      'vname' => 'LBL_SAFNFORMUR_TOLUSETNING_TIL',
      'type' => 'int',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'disable_num_format' => '',
    ),
    'safnformur_sendatil' => 
    array (
      'required' => false,
      'name' => 'safnformur_sendatil',
      'vname' => 'LBL_SAFNFORMUR_SENDATIL',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'safnformur_pdfsugar' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'safnformur_pdfsugar',
      'vname' => 'LBL_SAFNFORMUR_PDFSUGAR',
      'type' => 'FRPDFButton',
      'massupdate' => 0,
      'default' => 'Get PDF',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'ext2' => 'a183863a-c454-42ba-b5d9-000b1156e781',
      'studio' => 'visible',
    ),
    'safnformur_greidslumati' => 
    array (
      'required' => false,
      'name' => 'safnformur_greidslumati',
      'vname' => 'LBL_SAFNFORMUR_GREIDSLUMATI',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => 'stadgreidsla',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'greidslumati_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'vsoff_offset_id_c' => 
    array (
      'required' => false,
      'name' => 'vsoff_offset_id_c',
      'vname' => '',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => 36,
      'size' => '20',
    ),
    'safnformur_geravinnusedil' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'safnformur_geravinnusedil',
      'vname' => 'LBL_SAFNFORMUR_GERAVINNUSEDIL',
      'type' => 'FRPDFButton',
      'massupdate' => 0,
      'default' => 'Gera PDF',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'ext2' => 'deed3343-3947-4865-88fb-343fdc299d00',
      'studio' => 'visible',
    ),
    'safnformur_afgreidslusedill' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'safnformur_afgreidslusedill',
      'vname' => 'LBL_SAFNFORMUR_AFGREIDSLUSEDILL',
      'type' => 'FRPDFButton',
      'massupdate' => 0,
      'default' => 'Get PDF',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'ext2' => '887e8541-a561-42b3-b713-84c7cd11499b',
      'studio' => 'visible',
    ),
    'verd10_c' => 
    array (
      'labelValue' => 'Verð Akstur:',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd10_c',
      'vname' => 'LBL_VERD10',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => '5490',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Verd_akstur_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'vssaf_Safnformurverd10_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'vssaf_safnformur_leads' => 
    array (
      'name' => 'vssaf_safnformur_leads',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_leads',
      'source' => 'non-db',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_LEADS_FROM_LEADS_TITLE',
    ),
    'vssaf_safnformur_leads_name' => 
    array (
      'name' => 'vssaf_safnformur_leads_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_LEADS_FROM_LEADS_TITLE',
      'save' => true,
      'id_name' => 'vssaf_safn1531dsleads_ida',
      'link' => 'vssaf_safnformur_leads',
      'table' => 'leads',
      'module' => 'Leads',
      'rname' => 'name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
    ),
    'vssaf_safn1531dsleads_ida' => 
    array (
      'name' => 'vssaf_safn1531dsleads_ida',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_leads',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_LEADS_FROM_VSSAF_SAFNFORMUR_TITLE',
    ),
    'vssaf_safnformur_vsoff_offset' => 
    array (
      'name' => 'vssaf_safnformur_vsoff_offset',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_vsoff_offset',
      'source' => 'non-db',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_VSOFF_OFFSET_FROM_VSOFF_OFFSET_TITLE',
    ),
    'vssaf_safnformur_vsoff_offset_name' => 
    array (
      'name' => 'vssaf_safnformur_vsoff_offset_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_VSOFF_OFFSET_FROM_VSOFF_OFFSET_TITLE',
      'save' => true,
      'id_name' => 'vssaf_safn63df_offset_ida',
      'link' => 'vssaf_safnformur_vsoff_offset',
      'table' => 'vsoff_offset',
      'module' => 'vsoff_Offset',
      'rname' => 'name',
    ),
    'vssaf_safn63df_offset_ida' => 
    array (
      'name' => 'vssaf_safn63df_offset_ida',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_vsoff_offset',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_VSOFF_OFFSET_FROM_VSSAF_SAFNFORMUR_TITLE',
    ),
    'vssaf_safnformur_contacts' => 
    array (
      'name' => 'vssaf_safnformur_contacts',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_contacts',
      'source' => 'non-db',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_CONTACTS_FROM_CONTACTS_TITLE',
    ),
    'vssaf_safnformur_contacts_name' => 
    array (
      'name' => 'vssaf_safnformur_contacts_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_CONTACTS_FROM_CONTACTS_TITLE',
      'save' => true,
      'id_name' => 'vssaf_safnd89aontacts_ida',
      'link' => 'vssaf_safnformur_contacts',
      'table' => 'contacts',
      'module' => 'Contacts',
      'rname' => 'name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
    ),
    'vssaf_safnd89aontacts_ida' => 
    array (
      'name' => 'vssaf_safnd89aontacts_ida',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_contacts',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_CONTACTS_FROM_VSSAF_SAFNFORMUR_TITLE',
    ),
    'vssaf_safnformur_cases' => 
    array (
      'name' => 'vssaf_safnformur_cases',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_cases',
      'source' => 'non-db',
      'side' => 'right',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_CASES_FROM_CASES_TITLE',
    ),
    'vssaf_safnformur_accounts' => 
    array (
      'name' => 'vssaf_safnformur_accounts',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_accounts',
      'source' => 'non-db',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_ACCOUNTS_FROM_ACCOUNTS_TITLE',
    ),
    'vssaf_safnformur_accounts_name' => 
    array (
      'name' => 'vssaf_safnformur_accounts_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_ACCOUNTS_FROM_ACCOUNTS_TITLE',
      'save' => true,
      'id_name' => 'vssaf_safn6d97ccounts_ida',
      'link' => 'vssaf_safnformur_accounts',
      'table' => 'accounts',
      'module' => 'Accounts',
      'rname' => 'name',
    ),
    'vssaf_safn6d97ccounts_ida' => 
    array (
      'name' => 'vssaf_safn6d97ccounts_ida',
      'type' => 'link',
      'relationship' => 'vssaf_safnformur_accounts',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSSAF_SAFNFORMUR_ACCOUNTS_FROM_VSSAF_SAFNFORMUR_TITLE',
    ),
    'verd_lysing01_c' => 
    array (
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'verd_lysing01_c',
      'vname' => 'LBL_VERD_LYSING01',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_lysing01_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_pm01_c' => 
    array (
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'verd_pm01_c',
      'vname' => 'LBL_VERD_PM01',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_pm01_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd01_c' => 
    array (
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'verd01_c',
      'vname' => 'LBL_VERD01',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'vssaf_Safnformurverd01_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'currency_id' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'currency_id',
      'vname' => 'LBL_CURRENCY',
      'type' => 'currency_id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'dbType' => 'id',
      'studio' => 'visible',
      'function' => 
      array (
        'name' => 'getCurrencyDropDown',
        'returns' => 'html',
      ),
      'id' => 'vssaf_Safnformurcurrency_id',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_lysing02_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_lysing02_c',
      'vname' => 'LBL_VERD_LYSING02',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_lysing02_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_pm02_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_pm02_c',
      'vname' => 'LBL_VERD_PM02',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_pm02_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd02_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd02_c',
      'vname' => 'LBL_VERD02',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'vssaf_Safnformurverd02_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_lysing03_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_lysing03_c',
      'vname' => 'LBL_VERD_LYSING03',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_lysing03_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_pm03_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_pm03_c',
      'vname' => 'LBL_VERD_PM03',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_pm03_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd03_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd03_c',
      'vname' => 'LBL_VERD03',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'vssaf_Safnformurverd03_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_lysing04_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_lysing04_c',
      'vname' => 'LBL_VERD_LYSING04',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_lysing04_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_pm04_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_pm04_c',
      'vname' => 'LBL_VERD_PM04',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_pm04_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd04_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd04_c',
      'vname' => 'LBL_VERD04',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'vssaf_Safnformurverd04_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_lysing05_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_lysing05_c',
      'vname' => 'LBL_VERD_LYSING05',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_lysing05_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_pm05_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_pm05_c',
      'vname' => 'LBL_VERD_PM05',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_pm05_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd05_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd05_c',
      'vname' => 'LBL_VERD05',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'vssaf_Safnformurverd05_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_lysing06_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_lysing06_c',
      'vname' => 'LBL_VERD_LYSING06',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_lysing06_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_pm06_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_pm06_c',
      'vname' => 'LBL_VERD_PM06',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_pm06_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd06_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd06_c',
      'vname' => 'LBL_VERD06',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'vssaf_Safnformurverd06_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_lysing07_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_lysing07_c',
      'vname' => 'LBL_VERD_LYSING07',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_lysing07_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_pm07_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_pm07_c',
      'vname' => 'LBL_VERD_PM07',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_pm07_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd07_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd07_c',
      'vname' => 'LBL_VERD07',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'vssaf_Safnformurverd07_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_lysing08_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_lysing08_c',
      'vname' => 'LBL_VERD_LYSING08',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_lysing08_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_pm08_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_pm08_c',
      'vname' => 'LBL_VERD_PM08',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_pm08_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd08_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd08_c',
      'vname' => 'LBL_VERD08',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'vssaf_Safnformurverd08_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_pm10_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_pm10_c',
      'vname' => 'LBL_VERD_PM10',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => 'PM901',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_pm10_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_pm11_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_pm11_c',
      'vname' => 'LBL_VERD_PM11',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_pm11_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd11_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd11_c',
      'vname' => 'LBL_VERD11',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'vssaf_Safnformurverd11_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_pm12_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_pm12_c',
      'vname' => 'LBL_VERD_PM12',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_pm12_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd12_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd12_c',
      'vname' => 'LBL_VERD12',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'vssaf_Safnformurverd12_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd_pm13_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd_pm13_c',
      'vname' => 'LBL_VERD_PM13',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '5',
      'size' => '20',
      'id' => 'vssaf_Safnformurverd_pm13_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'verd13_c' => 
    array (
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'verd13_c',
      'vname' => 'LBL_VERD13',
      'type' => 'currency',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '26',
      'size' => '20',
      'enable_range_search' => false,
      'precision' => 6,
      'id' => 'vssaf_Safnformurverd13_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
    'safnformur_vinnus_c' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'safnformur_vinnus_c',
      'vname' => 'LBL_SAFNFORMUR_VINNUS',
      'type' => 'FRPDFButton',
      'massupdate' => '0',
      'default' => 'Gera vinnuseðil',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'ext2' => '6f700bea-7f82-4f68-b987-f61bb9902656',
      'studio' => 'visible',
      'id' => 'vssaf_Safnformursafnformur_vinnus_c',
      'custom_module' => 'vssaf_Safnformur',
    ),
  ),
  'relationships' => 
  array (
    'vssaf_safnformur_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'vssaf_Safnformur',
      'rhs_table' => 'vssaf_safnformur',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'vssaf_safnformur_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'vssaf_Safnformur',
      'rhs_table' => 'vssaf_safnformur',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'vssaf_safnformur_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'vssaf_Safnformur',
      'rhs_table' => 'vssaf_safnformur',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_locking' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'vssaf_safnformurpk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    'number' => 
    array (
      'name' => 'vssaf_safnformurnumk',
      'type' => 'unique',
      'fields' => 
      array (
        0 => 'vssaf_safnformur_number',
      ),
    ),
  ),
  'templates' => 
  array (
    'issue' => 'issue',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);