<?php 
 $GLOBALS["dictionary"]["vssti_Stimplar"]=array (
  'table' => 'vssti_stimplar',
  'audited' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_SUBJECT',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'audited' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'The short description of the bug',
      'merge_filter' => 'selected',
      'required' => true,
      'importable' => 'required',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'vssti_stimplar_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'vssti_stimplar_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'vssti_stimplar_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'vssti_stimplar_number' => 
    array (
      'name' => 'vssti_stimplar_number',
      'vname' => 'LBL_NUMBER',
      'type' => 'int',
      'readonly' => true,
      'len' => 11,
      'required' => true,
      'auto_increment' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'Visual unique identifier',
      'duplicate_merge' => 'disabled',
      'disable_num_format' => true,
      'studio' => 
      array (
        'quickcreate' => false,
      ),
    ),
    'type' => 
    array (
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'vssti_stimplar_type_dom',
      'len' => 255,
      'comment' => 'The type of issue (ex: issue, feature)',
      'merge_filter' => 'enabled',
    ),
    'status' => 
    array (
      'name' => 'status',
      'vname' => 'LBL_STATUS',
      'type' => 'enum',
      'options' => 'vssti_stimplar_status_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'The status of the issue',
      'merge_filter' => 'disabled',
      'default' => 'Closed',
      'required' => true,
      'massupdate' => '1',
      'comments' => 'The status of the issue',
    ),
    'priority' => 
    array (
      'name' => 'priority',
      'vname' => 'LBL_PRIORITY',
      'type' => 'enum',
      'options' => 'vssti_stimplar_priority_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'An indication of the priorty of the issue',
      'merge_filter' => 'enabled',
    ),
    'resolution' => 
    array (
      'name' => 'resolution',
      'vname' => 'LBL_RESOLUTION',
      'type' => 'enum',
      'options' => 'vssti_stimplar_resolution_dom',
      'len' => 255,
      'audited' => true,
      'comment' => 'An indication of how the issue was resolved',
      'merge_filter' => 'enabled',
    ),
    'work_log' => 
    array (
      'name' => 'work_log',
      'vname' => 'LBL_WORK_LOG',
      'type' => 'text',
      'comment' => 'Free-form text used to denote activities of interest',
    ),
    'stimplar_printyplastbox' => 
    array (
      'required' => false,
      'name' => 'stimplar_printyplastbox',
      'vname' => 'LBL_STIMPLAR_PRINTYPLASTBOX',
      'type' => 'multienum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'stimplar_printyplastbox_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'stimplar_printyplastboxdags' => 
    array (
      'required' => false,
      'name' => 'stimplar_printyplastboxdags',
      'vname' => 'LBL_STIMPLAR_PRINTYPLASTBOXDAGS',
      'type' => 'multienum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'stimplar_printyplastboxdags_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'stimplar_stell' => 
    array (
      'required' => false,
      'name' => 'stimplar_stell',
      'vname' => 'LBL_STIMPLAR_STELL',
      'type' => 'multienum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'stimplar_stell_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'stimplar_stelldags' => 
    array (
      'required' => false,
      'name' => 'stimplar_stelldags',
      'vname' => 'LBL_STIMPLAR_STELLDAGS',
      'type' => 'multienum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'stimplar_stelldags_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'stimplar_annad' => 
    array (
      'required' => false,
      'name' => 'stimplar_annad',
      'vname' => 'LBL_STIMPLAR_ANNAD',
      'type' => 'multienum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'stimplar_annad_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'stimplar_texti' => 
    array (
      'required' => false,
      'name' => 'stimplar_texti',
      'vname' => 'LBL_STIMPLAR_TEXTI',
      'type' => 'text',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
      'rows' => '8',
      'cols' => '120',
    ),
    'stimplar_annad_stort' => 
    array (
      'required' => false,
      'name' => 'stimplar_annad_stort',
      'vname' => 'LBL_STIMPLAR_ANNAD_STORT',
      'type' => 'text',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
      'rows' => '8',
      'cols' => '120',
    ),
    'stimplar_pudar' => 
    array (
      'required' => false,
      'name' => 'stimplar_pudar',
      'vname' => 'LBL_STIMPLAR_PUDAR',
      'type' => 'multienum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'stimplar_pudar_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'stimplar_ath' => 
    array (
      'required' => false,
      'name' => 'stimplar_ath',
      'vname' => 'LBL_STIMPLAR_ATH',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'stimplar_afhending' => 
    array (
      'required' => false,
      'name' => 'stimplar_afhending',
      'vname' => 'LBL_STIMPLAR_AFHENDING',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => 'Sottstadgreitt',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'stimplar_afhending_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'stimplar_oskasttilbuid' => 
    array (
      'required' => true,
      'name' => 'stimplar_oskasttilbuid',
      'vname' => 'LBL_STIMPLAR_OSKASTTILBUID',
      'type' => 'datetimecombo',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'dbType' => 'datetime',
    ),
    'vssti_stimplar_leads' => 
    array (
      'name' => 'vssti_stimplar_leads',
      'type' => 'link',
      'relationship' => 'vssti_stimplar_leads',
      'source' => 'non-db',
      'vname' => 'LBL_VSSTI_STIMPLAR_LEADS_FROM_LEADS_TITLE',
    ),
    'vssti_stimplar_leads_name' => 
    array (
      'name' => 'vssti_stimplar_leads_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSSTI_STIMPLAR_LEADS_FROM_LEADS_TITLE',
      'save' => true,
      'id_name' => 'vssti_stim61a7dsleads_ida',
      'link' => 'vssti_stimplar_leads',
      'table' => 'leads',
      'module' => 'Leads',
      'rname' => 'name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
    ),
    'vssti_stim61a7dsleads_ida' => 
    array (
      'name' => 'vssti_stim61a7dsleads_ida',
      'type' => 'link',
      'relationship' => 'vssti_stimplar_leads',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSSTI_STIMPLAR_LEADS_FROM_VSSTI_STIMPLAR_TITLE',
    ),
    'vssti_stimplar_accounts' => 
    array (
      'name' => 'vssti_stimplar_accounts',
      'type' => 'link',
      'relationship' => 'vssti_stimplar_accounts',
      'source' => 'non-db',
      'vname' => 'LBL_VSSTI_STIMPLAR_ACCOUNTS_FROM_ACCOUNTS_TITLE',
    ),
    'vssti_stimplar_accounts_name' => 
    array (
      'name' => 'vssti_stimplar_accounts_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSSTI_STIMPLAR_ACCOUNTS_FROM_ACCOUNTS_TITLE',
      'save' => true,
      'id_name' => 'vssti_stimc189ccounts_ida',
      'link' => 'vssti_stimplar_accounts',
      'table' => 'accounts',
      'module' => 'Accounts',
      'rname' => 'name',
    ),
    'vssti_stimc189ccounts_ida' => 
    array (
      'name' => 'vssti_stimc189ccounts_ida',
      'type' => 'link',
      'relationship' => 'vssti_stimplar_accounts',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSSTI_STIMPLAR_ACCOUNTS_FROM_VSSTI_STIMPLAR_TITLE',
    ),
    'vssti_stimplar_contacts' => 
    array (
      'name' => 'vssti_stimplar_contacts',
      'type' => 'link',
      'relationship' => 'vssti_stimplar_contacts',
      'source' => 'non-db',
      'vname' => 'LBL_VSSTI_STIMPLAR_CONTACTS_FROM_CONTACTS_TITLE',
    ),
    'vssti_stimplar_contacts_name' => 
    array (
      'name' => 'vssti_stimplar_contacts_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSSTI_STIMPLAR_CONTACTS_FROM_CONTACTS_TITLE',
      'save' => true,
      'id_name' => 'vssti_stim22e8ontacts_ida',
      'link' => 'vssti_stimplar_contacts',
      'table' => 'contacts',
      'module' => 'Contacts',
      'rname' => 'name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
    ),
    'vssti_stim22e8ontacts_ida' => 
    array (
      'name' => 'vssti_stim22e8ontacts_ida',
      'type' => 'link',
      'relationship' => 'vssti_stimplar_contacts',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSSTI_STIMPLAR_CONTACTS_FROM_VSSTI_STIMPLAR_TITLE',
    ),
    'vssti_stimplar_cases' => 
    array (
      'name' => 'vssti_stimplar_cases',
      'type' => 'link',
      'relationship' => 'vssti_stimplar_cases',
      'source' => 'non-db',
      'side' => 'right',
      'vname' => 'LBL_VSSTI_STIMPLAR_CASES_FROM_CASES_TITLE',
    ),
  ),
  'relationships' => 
  array (
    'vssti_stimplar_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'vssti_Stimplar',
      'rhs_table' => 'vssti_stimplar',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'vssti_stimplar_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'vssti_Stimplar',
      'rhs_table' => 'vssti_stimplar',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'vssti_stimplar_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'vssti_Stimplar',
      'rhs_table' => 'vssti_stimplar',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_locking' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'vssti_stimplarpk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    'number' => 
    array (
      'name' => 'vssti_stimplarnumk',
      'type' => 'unique',
      'fields' => 
      array (
        0 => 'vssti_stimplar_number',
      ),
    ),
  ),
  'templates' => 
  array (
    'issue' => 'issue',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => false,
);