<?php 
 $GLOBALS["dictionary"]["vsumb_Umbudir"]=array (
  'table' => 'vsumb_umbudir',
  'audited' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_SUBJECT',
      'type' => 'name',
      'dbType' => 'varchar',
      'len' => '255',
      'audited' => true,
      'unified_search' => true,
      'comment' => 'The short description of the bug',
      'merge_filter' => 'selected',
      'required' => true,
      'importable' => 'required',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'reportable' => true,
      'size' => '20',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => '6',
      'cols' => '80',
      'required' => false,
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'vsumb_umbudir_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'vsumb_umbudir_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'name',
      'type' => 'relate',
      'reportable' => true,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => '_id_c',
      'module' => '',
      'duplicate_merge' => 'disabled',
      'required' => false,
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'len' => '255',
      'size' => '20',
      'ext2' => '',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'merge_filter' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'vsumb_umbudir_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'vsumb_umbudir_number' => 
    array (
      'name' => 'vsumb_umbudir_number',
      'vname' => 'LBL_NUMBER',
      'type' => 'int',
      'readonly' => true,
      'len' => 11,
      'required' => true,
      'auto_increment' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'Visual unique identifier',
      'duplicate_merge' => 'disabled',
      'disable_num_format' => true,
      'studio' => 
      array (
        'quickcreate' => false,
      ),
      'autoinc_next' => '4854',
    ),
    'type' => 
    array (
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'vsumb_umbudir_type_dom',
      'len' => 255,
      'comment' => 'The type of issue (ex: issue, feature)',
      'merge_filter' => 'enabled',
    ),
    'status' => 
    array (
      'name' => 'status',
      'vname' => 'LBL_STATUS',
      'type' => 'enum',
      'options' => 'vsumb_umbudir_status_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'The status of the issue',
      'merge_filter' => 'disabled',
      'default' => 'Assigned',
      'required' => true,
      'massupdate' => '1',
      'comments' => 'The status of the issue',
    ),
    'priority' => 
    array (
      'name' => 'priority',
      'vname' => 'LBL_PRIORITY',
      'type' => 'enum',
      'options' => 'vsumb_umbudir_priority_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'An indication of the priorty of the issue',
      'merge_filter' => 'enabled',
      'required' => false,
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'resolution' => 
    array (
      'name' => 'resolution',
      'vname' => 'LBL_RESOLUTION',
      'type' => 'enum',
      'options' => 'vsumb_umbudir_resolution_dom',
      'len' => 255,
      'audited' => true,
      'comment' => 'An indication of how the issue was resolved',
      'merge_filter' => 'enabled',
    ),
    'work_log' => 
    array (
      'name' => 'work_log',
      'vname' => 'LBL_WORK_LOG',
      'type' => 'text',
      'comment' => 'Free-form text used to denote activities of interest',
    ),
    'umbudir_velar' => 
    array (
      'required' => false,
      'name' => 'umbudir_velar',
      'vname' => 'LBL_UMBUDIR_VELAR',
      'type' => 'multienum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'size' => '20',
      'options' => 'umbudir_velar_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'umbudir_grafik' => 
    array (
      'required' => false,
      'name' => 'umbudir_grafik',
      'vname' => 'LBL_UMBUDIR_GRAFIK',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_gerahogg' => 
    array (
      'required' => false,
      'name' => 'umbudir_gerahogg',
      'vname' => 'LBL_UMBUDIR_GERAHOGG',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_formhonnun' => 
    array (
      'required' => false,
      'name' => 'umbudir_formhonnun',
      'vname' => 'LBL_UMBUDIR_FORMHONNUN',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_upplag' => 
    array (
      'required' => false,
      'name' => 'umbudir_upplag',
      'vname' => 'LBL_UMBUDIR_UPPLAG',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_arkarfjoldi' => 
    array (
      'required' => false,
      'name' => 'umbudir_arkarfjoldi',
      'vname' => 'LBL_UMBUDIR_ARKARFJOLDI',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_fjoldia' => 
    array (
      'required' => false,
      'name' => 'umbudir_fjoldia',
      'vname' => 'LBL_UMBUDIR_FJOLDIA',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_litur' => 
    array (
      'required' => false,
      'name' => 'umbudir_litur',
      'vname' => 'LBL_UMBUDIR_LITUR',
      'type' => 'multienum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'options' => 'umbudir_litur_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
    ),
    'umbudir_liturnanar' => 
    array (
      'required' => false,
      'name' => 'umbudir_liturnanar',
      'vname' => 'LBL_UMBUDIR_LITURNANAR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_liming' => 
    array (
      'required' => false,
      'name' => 'umbudir_liming',
      'vname' => 'LBL_UMBUDIR_LIMING',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_liminglakk' => 
    array (
      'required' => false,
      'name' => 'umbudir_liminglakk',
      'vname' => 'LBL_UMBUDIR_LIMINGLAKK',
      'type' => 'enum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'umbudir_liminglakk_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'umbudir_prentun' => 
    array (
      'required' => true,
      'name' => 'umbudir_prentun',
      'vname' => 'LBL_UMBUDIR_PRENTUN ',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'size' => '20',
      'options' => 'umbudir_prentun_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
      'len' => 100,
      'dependency' => false,
    ),
    'umbudir_tekinutprentun' => 
    array (
      'required' => false,
      'name' => 'umbudir_tekinutprentun',
      'vname' => 'LBL_UMBUDIR_TEKINUTPRENTUN',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_rasti' => 
    array (
      'required' => true,
      'name' => 'umbudir_rasti',
      'vname' => 'LBL_UMBUDIR_RASTI ',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'size' => '20',
      'options' => 'umbudir_rasti_list',
      'studio' => 'visible',
      'isMultiSelect' => true,
      'len' => 100,
      'dependency' => false,
    ),
    'umbudir_formafj4lit' => 
    array (
      'required' => true,
      'name' => 'umbudir_formafj4lit',
      'vname' => 'LBL_UMBUDIR_FORMAFJ4LIT',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_formfjsvartur' => 
    array (
      'required' => true,
      'name' => 'umbudir_formfjsvartur',
      'vname' => 'LBL_UMBUDIR_FORMFJSVARTUR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_formfjannad' => 
    array (
      'required' => true,
      'name' => 'umbudir_formfjannad',
      'vname' => 'LBL_UMBUDIR_FORMFJANNAD',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_samthykkiprofork' => 
    array (
      'required' => false,
      'name' => 'umbudir_samthykkiprofork',
      'vname' => 'LBL_UMBUDIR_SAMTHYKKIPROFORK',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_latasamthykkjaform' => 
    array (
      'required' => false,
      'name' => 'umbudir_latasamthykkjaform',
      'vname' => 'LBL_UMBUDIR_LATASAMTHYKKJAFORM',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_pappir01' => 
    array (
      'required' => true,
      'name' => 'umbudir_pappir01',
      'vname' => 'LBL_UMBUDIR_PAPPIR01',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_pappirthyngd01' => 
    array (
      'required' => false,
      'name' => 'umbudir_pappirthyngd01',
      'vname' => 'LBL_UMBUDIR_PAPPIRTHYNGD01',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_pappirstaerd01' => 
    array (
      'required' => true,
      'name' => 'umbudir_pappirstaerd01',
      'vname' => 'LBL_UMBUDIR_PAPPIRSTAERD01',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_pappirlega01' => 
    array (
      'required' => true,
      'name' => 'umbudir_pappirlega01',
      'vname' => 'LBL_UMBUDIR_PAPPIRLEGA01',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'umbudir_pappirlega01_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'umbudir_pappir02' => 
    array (
      'required' => false,
      'name' => 'umbudir_pappir02',
      'vname' => 'LBL_UMBUDIR_PAPPIR02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_pappirthyngd02' => 
    array (
      'required' => false,
      'name' => 'umbudir_pappirthyngd02',
      'vname' => 'LBL_UMBUDIR_PAPPIRTHYNGD02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_pappirstaerd02' => 
    array (
      'required' => false,
      'name' => 'umbudir_pappirstaerd02',
      'vname' => 'LBL_UMBUDIR_PAPPIRSTAERD02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_pappirlega02' => 
    array (
      'required' => false,
      'name' => 'umbudir_pappirlega02',
      'vname' => 'LBL_UMBUDIR_PAPPIRLEGA02',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'umbudir_pappirlega01_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'umbudir_pappirerafskurdur' => 
    array (
      'required' => false,
      'name' => 'umbudir_pappirerafskurdur',
      'vname' => 'LBL_UMBUDIR_PAPPIRERAFSKURDUR',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_geymaafskurd' => 
    array (
      'required' => false,
      'name' => 'umbudir_geymaafskurd',
      'vname' => 'LBL_UMBUDIR_GEYMAAFSKURD',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_skoridur' => 
    array (
      'required' => false,
      'name' => 'umbudir_skoridur',
      'vname' => 'LBL_UMBUDIR_SKORIDUR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_ogendari' => 
    array (
      'required' => false,
      'name' => 'umbudir_ogendari',
      'vname' => 'LBL_UMBUDIR_OGENDARI',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_annad' => 
    array (
      'required' => false,
      'name' => 'umbudir_annad',
      'vname' => 'LBL_UMBUDIR_ANNAD',
      'type' => 'text',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
      'rows' => '8',
      'cols' => '120',
    ),
    'umbudir_geralakkdekk' => 
    array (
      'required' => false,
      'name' => 'umbudir_geralakkdekk',
      'vname' => 'LBL_UMBUDIR_GERALAKKDEKK',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_lakkdekktil' => 
    array (
      'required' => false,
      'name' => 'umbudir_lakkdekktil',
      'vname' => 'LBL_UMBUDIR_LAKKDEKKTIL',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'offset_prentplotur' => 
    array (
      'required' => false,
      'name' => 'offset_prentplotur',
      'vname' => 'LBL_OFFSET_PRENTPLOTUR',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_prentplotur_0',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'umbudir_ath' => 
    array (
      'required' => false,
      'name' => 'umbudir_ath',
      'vname' => 'LBL_UMBUDIR_ATH',
      'type' => 'text',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'size' => '20',
      'studio' => 'visible',
      'rows' => '2',
      'cols' => '120',
    ),
    'umbudir_pokkun' => 
    array (
      'required' => false,
      'name' => 'umbudir_pokkun',
      'vname' => 'LBL_UMBUDIR_POKKUN',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_afhending' => 
    array (
      'required' => true,
      'name' => 'umbudir_afhending',
      'vname' => 'LBL_UMBUDIR_AFHENDING',
      'type' => 'enum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'umbudir_afhending_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'umbudir_afhendingnanar' => 
    array (
      'required' => false,
      'name' => 'umbudir_afhendingnanar',
      'vname' => 'LBL_UMBUDIR_AFHENDINGNANAR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_hringja' => 
    array (
      'required' => false,
      'name' => 'umbudir_hringja',
      'vname' => 'LBL_UMBUDIR_HRINGJA',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_oskasttilbuid' => 
    array (
      'required' => true,
      'name' => 'umbudir_oskasttilbuid',
      'vname' => 'LBL_UMBUDIR_OSKASTTILBUID',
      'type' => 'datetimecombo',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'size' => '20',
      'dbType' => 'datetime',
      'options' => 'date_range_search_dom',
      'merge_filter' => 'disabled',
      'enable_range_search' => '1',
    ),
    'umbudir_vorunumer' => 
    array (
      'required' => true,
      'name' => 'umbudir_vorunumer',
      'vname' => 'LBL_UMBUDIR_VORUNUMER',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_framleittmagn' => 
    array (
      'required' => false,
      'name' => 'umbudir_framleittmagn',
      'vname' => 'LBL_UMBUDIR_FRAMLEITTMAGN',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_thyngdvara' => 
    array (
      'required' => false,
      'name' => 'umbudir_thyngdvara',
      'vname' => 'LBL_UMBUDIR_THYNGDVARA',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_thyngdtoru' => 
    array (
      'required' => false,
      'name' => 'umbudir_thyngdtoru',
      'vname' => 'LBL_UMBUDIR_THYNGDTORU',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_flokkur' => 
    array (
      'required' => true,
      'name' => 'umbudir_flokkur',
      'vname' => 'LBL_UMBUDIR_FLOKKUR',
      'type' => 'enum',
      'massupdate' => '1',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'umbudir_flokkur_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'umbudir_svansmerkt' => 
    array (
      'required' => false,
      'name' => 'umbudir_svansmerkt',
      'vname' => 'LBL_UMBUDIR_SVANSMERKT',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'umbudir_svansmerkt_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'umbudir_prentvelar' => 
    array (
      'required' => true,
      'name' => 'umbudir_prentvelar',
      'vname' => 'LBL_UMBUDIR_PRENTVELAR',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'umbudir_prentvelar_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'umbudir_stansvelar' => 
    array (
      'required' => true,
      'name' => 'umbudir_stansvelar',
      'vname' => 'LBL_UMBUDIR_STANSVELAR',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'umbudir_stansvelar_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'umbudir_fragangsvelar' => 
    array (
      'required' => true,
      'name' => 'umbudir_fragangsvelar',
      'vname' => 'LBL_UMBUDIR_FRAGANGSVELAR',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'umbudir_fragangsvelar_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'umbudir_tilalager' => 
    array (
      'required' => false,
      'name' => 'umbudir_tilalager',
      'vname' => 'LBL_UMBUDIR_TILALAGER',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_pappirkemurfra' => 
    array (
      'required' => false,
      'name' => 'umbudir_pappirkemurfra',
      'vname' => 'LBL_UMBUDIR_PAPPIRKEMURFRA',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '30',
      'size' => '20',
    ),
    'umbudir_endurprentun' => 
    array (
      'required' => false,
      'name' => 'umbudir_endurprentun',
      'vname' => 'LBL_UMBUDIR_ENDURPRENTUN',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_endurprentun_dags01' => 
    array (
      'required' => false,
      'name' => 'umbudir_endurprentun_dags01',
      'vname' => 'LBL_UMBUDIR_ENDURPRENTUN_DAGS01',
      'type' => 'date',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'size' => '20',
    ),
    'umbudir_endurprentun_dags02' => 
    array (
      'required' => false,
      'name' => 'umbudir_endurprentun_dags02',
      'vname' => 'LBL_UMBUDIR_ENDURPRENTUN_DAGS02',
      'type' => 'date',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'size' => '20',
    ),
    'umbudir_endurprentun_vnr01' => 
    array (
      'required' => false,
      'name' => 'umbudir_endurprentun_vnr01',
      'vname' => 'LBL_UMBUDIR_ENDURPRENTUN_VNR01',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '10',
      'size' => '20',
    ),
    'umbudir_stadgreitt' => 
    array (
      'required' => false,
      'name' => 'umbudir_stadgreitt',
      'vname' => 'LBL_UMBUDIR_STADGREITT',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_synishornaugl' => 
    array (
      'required' => false,
      'name' => 'umbudir_synishornaugl',
      'vname' => 'LBL_UMBUDIR_SYNISHORNAUGL',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_solumadur' => 
    array (
      'required' => true,
      'name' => 'umbudir_solumadur',
      'vname' => 'LBL_UMBUDIR_SOLUMADUR',
      'type' => 'enum',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'offset_solumenn_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'umbudir_simi' => 
    array (
      'required' => false,
      'name' => 'umbudir_simi',
      'vname' => 'LBL_UMBUDIR_SIMI',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '15',
      'size' => '20',
    ),
    'umbudir_email' => 
    array (
      'required' => false,
      'name' => 'umbudir_email',
      'vname' => 'LBL_UMBUDIR_EMAIL',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '40',
      'size' => '20',
    ),
    'umbudir_greidandi' => 
    array (
      'required' => false,
      'name' => 'umbudir_greidandi',
      'vname' => 'LBL_UMBUDIR_GREIDANDI',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '40',
      'size' => '20',
    ),
    'umbudir_umbedidaf' => 
    array (
      'required' => false,
      'name' => 'umbudir_umbedidaf',
      'vname' => 'LBL_UMBUDIR_UMBEDIDAF',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '40',
      'size' => '20',
    ),
    'umbudir_4litur' => 
    array (
      'required' => false,
      'name' => 'umbudir_4litur',
      'vname' => 'LBL_UMBUDIR_4LITUR',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_svartur' => 
    array (
      'required' => false,
      'name' => 'umbudir_svartur',
      'vname' => 'LBL_UMBUDIR_SVARTUR',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_spotlitur' => 
    array (
      'required' => false,
      'name' => 'umbudir_spotlitur',
      'vname' => 'LBL_UMBUDIR_SPOTLITUR',
      'type' => 'bool',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
    ),
    'umbudir_endurprentun_vnr02' => 
    array (
      'required' => false,
      'name' => 'umbudir_endurprentun_vnr02',
      'vname' => 'LBL_UMBUDIR_ENDURPRENTUN_VNR02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '10',
      'size' => '20',
    ),
    'umbudir_pdfsugar' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'umbudir_pdfsugar',
      'vname' => 'LBL_UMBUDIR_PDFSUGAR',
      'type' => 'FRPDFButton',
      'massupdate' => 0,
      'default' => 'Gera PDF',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'ext2' => '398779a1-b898-4555-8b5c-2d1497a9348c',
      'studio' => 'visible',
    ),
    'umbudir_hoggnr' => 
    array (
      'required' => false,
      'name' => 'umbudir_hoggnr',
      'vname' => 'LBL_UMBUDIR_HOGGNR',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '30',
      'size' => '20',
    ),
    'umbudir_lakk' => 
    array (
      'required' => false,
      'name' => 'umbudir_lakk',
      'vname' => 'LBL_UMBUDIR_LAKK',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '30',
      'size' => '20',
    ),
    '_id_c' => 
    array (
      'required' => false,
      'name' => '_id_c',
      'vname' => '',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => 36,
      'size' => '20',
    ),
    'verd01' => 
    array (
      'required' => true,
      'name' => 'verd01',
      'vname' => 'LBL_VERD01',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'currency_id' => 
    array (
      'required' => false,
      'name' => 'currency_id',
      'vname' => 'LBL_CURRENCY',
      'type' => 'id',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => 36,
      'size' => '20',
      'studio' => 'visible',
      'function' => 
      array (
        'name' => 'getCurrencyDropDown',
        'returns' => 'html',
      ),
    ),
    'verd_pm01' => 
    array (
      'required' => true,
      'name' => 'verd_pm01',
      'vname' => 'LBL_VERD_PM01',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd_lysing01' => 
    array (
      'required' => true,
      'name' => 'verd_lysing01',
      'vname' => 'LBL_VERD_LYSING01',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '50',
      'size' => '20',
    ),
    'verd02' => 
    array (
      'required' => false,
      'name' => 'verd02',
      'vname' => 'LBL_VERD02',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm02' => 
    array (
      'required' => false,
      'name' => 'verd_pm02',
      'vname' => 'LBL_VERD_PM02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd_lysing02' => 
    array (
      'required' => false,
      'name' => 'verd_lysing02',
      'vname' => 'LBL_VERD_LYSING02',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '50',
      'size' => '20',
    ),
    'verd03' => 
    array (
      'required' => false,
      'name' => 'verd03',
      'vname' => 'LBL_VERD03',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm03' => 
    array (
      'required' => false,
      'name' => 'verd_pm03',
      'vname' => 'LBL_VERD_PM03',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd_lysing03' => 
    array (
      'required' => false,
      'name' => 'verd_lysing03',
      'vname' => 'LBL_VERD_LYSING03',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '50',
      'size' => '20',
    ),
    'verd04' => 
    array (
      'required' => false,
      'name' => 'verd04',
      'vname' => 'LBL_VERD04',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm04' => 
    array (
      'required' => false,
      'name' => 'verd_pm04',
      'vname' => 'LBL_VERD_PM04',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd_lysing04' => 
    array (
      'required' => false,
      'name' => 'verd_lysing04',
      'vname' => 'LBL_VERD_LYSING04',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '50',
      'size' => '20',
    ),
    'verd05' => 
    array (
      'required' => false,
      'name' => 'verd05',
      'vname' => 'LBL_VERD05',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm05' => 
    array (
      'required' => false,
      'name' => 'verd_pm05',
      'vname' => 'LBL_VERD_PM05',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd_lysing05' => 
    array (
      'required' => false,
      'name' => 'verd_lysing05',
      'vname' => 'LBL_VERD_LYSING05',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '50',
      'size' => '20',
    ),
    'verd06' => 
    array (
      'required' => false,
      'name' => 'verd06',
      'vname' => 'LBL_VERD06',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm06' => 
    array (
      'required' => false,
      'name' => 'verd_pm06',
      'vname' => 'LBL_VERD_PM06',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd_lysing06' => 
    array (
      'required' => false,
      'name' => 'verd_lysing06',
      'vname' => 'LBL_VERD_LYSING06',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '50',
      'size' => '20',
    ),
    'verd07' => 
    array (
      'required' => false,
      'name' => 'verd07',
      'vname' => 'LBL_VERD07',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm07' => 
    array (
      'required' => false,
      'name' => 'verd_pm07',
      'vname' => 'LBL_VERD_PM07',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd_lysing07' => 
    array (
      'required' => false,
      'name' => 'verd_lysing07',
      'vname' => 'LBL_VERD_LYSING07',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '50',
      'size' => '20',
    ),
    'verd08' => 
    array (
      'required' => false,
      'name' => 'verd08',
      'vname' => 'LBL_VERD08',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm08' => 
    array (
      'required' => false,
      'name' => 'verd_pm08',
      'vname' => 'LBL_VERD_PM08',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd_lysing08' => 
    array (
      'required' => false,
      'name' => 'verd_lysing08',
      'vname' => 'LBL_VERD_LYSING08',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '50',
      'size' => '20',
    ),
    'verd10' => 
    array (
      'required' => false,
      'name' => 'verd10',
      'vname' => 'LBL_VERD10',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => '13990',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 100,
      'size' => '20',
      'options' => 'Verd_akstur_list',
      'studio' => 'visible',
      'dependency' => false,
      'merge_filter' => 'disabled',
    ),
    'verd_pm10' => 
    array (
      'required' => false,
      'name' => 'verd_pm10',
      'vname' => 'LBL_VERD_PM10',
      'type' => 'varchar',
      'massupdate' => 0,
      'default' => 'PM901',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd11' => 
    array (
      'required' => false,
      'name' => 'verd11',
      'vname' => 'LBL_VERD11',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm11' => 
    array (
      'required' => false,
      'name' => 'verd_pm11',
      'vname' => 'LBL_VERD_PM11',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd12' => 
    array (
      'required' => false,
      'name' => 'verd12',
      'vname' => 'LBL_VERD12',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm12' => 
    array (
      'required' => false,
      'name' => 'verd_pm12',
      'vname' => 'LBL_VERD_PM12',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'verd13' => 
    array (
      'required' => false,
      'name' => 'verd13',
      'vname' => 'LBL_VERD13',
      'type' => 'currency',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => 26,
      'size' => '20',
    ),
    'verd_pm13' => 
    array (
      'required' => false,
      'name' => 'verd_pm13',
      'vname' => 'LBL_VERD_PM13',
      'type' => 'varchar',
      'massupdate' => 0,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'len' => '5',
      'size' => '20',
    ),
    'umbudir_pdfvinnusedill' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'umbudir_pdfvinnusedill',
      'vname' => 'LBL_UMBUDIR_PDFVINNUSEDILL',
      'type' => 'FRPDFButton',
      'massupdate' => 0,
      'default' => 'Gera PDF',
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => true,
      'len' => '255',
      'size' => '20',
      'ext2' => 'deed3343-3947-4865-88fb-343fdc299d00',
      'studio' => 'visible',
    ),
    'vsumb_umbudir_cases' => 
    array (
      'name' => 'vsumb_umbudir_cases',
      'type' => 'link',
      'relationship' => 'vsumb_umbudir_cases',
      'source' => 'non-db',
      'side' => 'right',
      'vname' => 'LBL_VSUMB_UMBUDIR_CASES_FROM_CASES_TITLE',
    ),
    'vsumb_umbudir_contacts' => 
    array (
      'name' => 'vsumb_umbudir_contacts',
      'type' => 'link',
      'relationship' => 'vsumb_umbudir_contacts',
      'source' => 'non-db',
      'vname' => 'LBL_VSUMB_UMBUDIR_CONTACTS_FROM_CONTACTS_TITLE',
    ),
    'vsumb_umbud_contacts_name' => 
    array (
      'name' => 'vsumb_umbud_contacts_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSUMB_UMBUDIR_CONTACTS_FROM_CONTACTS_TITLE',
      'save' => true,
      'id_name' => 'vsumb_umbu95baontacts_ida',
      'link' => 'vsumb_umbudir_contacts',
      'table' => 'contacts',
      'module' => 'Contacts',
      'rname' => 'name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
    ),
    'vsumb_umbu95baontacts_ida' => 
    array (
      'name' => 'vsumb_umbu95baontacts_ida',
      'type' => 'link',
      'relationship' => 'vsumb_umbudir_contacts',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSUMB_UMBUDIR_CONTACTS_FROM_VSUMB_UMBUDIR_TITLE',
    ),
    'vsumb_umbudir_accounts' => 
    array (
      'name' => 'vsumb_umbudir_accounts',
      'type' => 'link',
      'relationship' => 'vsumb_umbudir_accounts',
      'source' => 'non-db',
      'vname' => 'LBL_VSUMB_UMBUDIR_ACCOUNTS_FROM_ACCOUNTS_TITLE',
    ),
    'vsumb_umbud_accounts_name' => 
    array (
      'name' => 'vsumb_umbud_accounts_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSUMB_UMBUDIR_ACCOUNTS_FROM_ACCOUNTS_TITLE',
      'save' => true,
      'id_name' => 'vsumb_umbufe4dccounts_ida',
      'link' => 'vsumb_umbudir_accounts',
      'table' => 'accounts',
      'module' => 'Accounts',
      'rname' => 'name',
    ),
    'vsumb_umbufe4dccounts_ida' => 
    array (
      'name' => 'vsumb_umbufe4dccounts_ida',
      'type' => 'link',
      'relationship' => 'vsumb_umbudir_accounts',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSUMB_UMBUDIR_ACCOUNTS_FROM_VSUMB_UMBUDIR_TITLE',
    ),
    'vsumb_umbudir_leads' => 
    array (
      'name' => 'vsumb_umbudir_leads',
      'type' => 'link',
      'relationship' => 'vsumb_umbudir_leads',
      'source' => 'non-db',
      'vname' => 'LBL_VSUMB_UMBUDIR_LEADS_FROM_LEADS_TITLE',
    ),
    'vsumb_umbudir_leads_name' => 
    array (
      'name' => 'vsumb_umbudir_leads_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_VSUMB_UMBUDIR_LEADS_FROM_LEADS_TITLE',
      'save' => true,
      'id_name' => 'vsumb_umbu7f00dsleads_ida',
      'link' => 'vsumb_umbudir_leads',
      'table' => 'leads',
      'module' => 'Leads',
      'rname' => 'name',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
    ),
    'vsumb_umbu7f00dsleads_ida' => 
    array (
      'name' => 'vsumb_umbu7f00dsleads_ida',
      'type' => 'link',
      'relationship' => 'vsumb_umbudir_leads',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_VSUMB_UMBUDIR_LEADS_FROM_VSUMB_UMBUDIR_TITLE',
    ),
    'umbudir_pontunarnumer_c' => 
    array (
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'umbudir_pontunarnumer_c',
      'vname' => 'LBL_UMBUDIR_PONTUNARNUMER',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'vsumb_Umbudirumbudir_pontunarnumer_c',
      'custom_module' => 'vsumb_Umbudir',
    ),
  ),
  'relationships' => 
  array (
    'vsumb_umbudir_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'vsumb_Umbudir',
      'rhs_table' => 'vsumb_umbudir',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'vsumb_umbudir_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'vsumb_Umbudir',
      'rhs_table' => 'vsumb_umbudir',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'vsumb_umbudir_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'vsumb_Umbudir',
      'rhs_table' => 'vsumb_umbudir',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_locking' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'vsumb_umbudirpk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    'number' => 
    array (
      'name' => 'vsumb_umbudirnumk',
      'type' => 'unique',
      'fields' => 
      array (
        0 => 'vsumb_umbudir_number',
      ),
    ),
  ),
  'templates' => 
  array (
    'issue' => 'issue',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);